from datetime import datetime, timedelta
from scripts.constants.app_configuration import DateRange,ReqTimeZone
from loguru import logger
import pytz


class KairosStartEndDate:

    @staticmethod
    def start_end_date():
        try:
            local_timezone = pytz.timezone(ReqTimeZone.required_tz)
            start_date_timestamp = DateRange.start_date
            end_date_timestamp = DateRange.end_date
            if (start_date_timestamp is not None) and (start_date_timestamp.lower() != "none"):
                start_date = datetime.fromtimestamp((int(start_date_timestamp)/1000)).strftime('%Y-%m-%d %H:%M:%S')
                start_date = datetime.strptime(start_date, "%Y-%m-%d %H:%M:%S")
                start_date = start_date.astimezone(local_timezone).replace(hour=5, minute=0, second=0, microsecond=0)
            else:
                start_date = datetime.now(pytz.utc) - timedelta(days=int(DateRange.start_relative_days))
                start_date = start_date.astimezone(local_timezone).replace(hour=5, minute=0, second=0, microsecond=0)
            
            if (end_date_timestamp is not None) and (end_date_timestamp.lower() != "none"):
                end_date = datetime.fromtimestamp((int(end_date_timestamp)/1000)).strftime('%Y-%m-%d %H:%M:%S')
                end_date = datetime.strptime(end_date, "%Y-%m-%d %H:%M:%S")
                end_date = end_date.astimezone(local_timezone).replace(hour=5, minute=0, second=0, microsecond=0)
            else:
                end_date = datetime.now(pytz.utc) - timedelta(days=int(DateRange.end_relative_days))
                end_date = end_date.astimezone(local_timezone).replace(hour=5, minute=0, second=0, microsecond=0)

            start_timestamp = int(start_date.timestamp())*1000
            end_timestamp = int(end_date.timestamp())*1000
            return start_date, end_date, start_timestamp, end_timestamp
        except Exception as e:
            logger.exception(f"Exception - {e}")
