import pandas as pd
from loguru import logger


class GetData:
    @staticmethod
    def current_voltage_mppt_data(df):
        try:
            current_column_list = [col_name for col_name in df if 'current' in col_name]
            voltage_column_list = [col_name for col_name in df if 'voltage' in col_name]
            current_column_list.sort()
            voltage_column_list.sort()

            df_mppt = pd.DataFrame()
            for n_mppt in range(len(current_column_list)):
                df_temp = df[['datetime', 'inv_id', 'date', 'hour', 'tilt_irradiance', voltage_column_list[n_mppt],
                              current_column_list[n_mppt]]]
                df_temp['mppt_id'] = current_column_list[n_mppt]
                df_temp['mppt_id'] = df_temp['mppt_id'].str.replace('current_', '')
                df_temp.rename(columns={voltage_column_list[n_mppt]: 'voltage_mppt',
                                        current_column_list[n_mppt]: 'current_mppt'}, inplace=True)
                if df_mppt.empty:
                    df_mppt = df_temp
                else:
                    df_mppt = pd.concat([df_mppt, df_temp], axis=0)
                    df_mppt.reset_index(drop=True, inplace=True)
            df_mppt.sort_values(['inv_id', 'mppt_id'], inplace=True)
            df_mppt.reset_index(drop=True, inplace=True)
            return df_mppt
        except Exception as e:
            logger.exception(f'Exception - {e}')



