from loguru import logger
from scripts.core.data_puller_push.push_data import insert_values_dalmia


class CalculatedDataPush:

    def __init__(self, df_result, final_tags_dict):
        self.df_result = df_result
        self.final_tags_dict = final_tags_dict

    def kafka_data_push(self):
        try:
            logger.info(f"final_tags_dict = {self.final_tags_dict}")
            logger.info(f"df result shape = {self.df_result.shape}")
            for i, j in self.df_result.iterrows():
                my_dict = {v: j[k] for k, v in self.final_tags_dict.items()}
                logger.info(f"{j['timestamp'], j['datetime'], my_dict}")
                insert_values_dalmia(j['timestamp'], my_dict)
        except Exception as e:
            logger.exception(f'Exception - {e}')
