import pandas as pd
from loguru import logger


class GetData:
    @staticmethod
    def current_voltage_mppt_data(df):
        try:
            current_column_list = [col_name for col_name in df if 'current' in col_name]
            voltage_column_list = [col_name for col_name in df if 'voltage' in col_name]
            current_column_list.sort()
            voltage_column_list.sort()

            df_mppt = pd.DataFrame()
            for n_mppt in range(len(current_column_list)):
                df_temp = df[['datetime', 'inv_id', 'date', 'hour', 'tilt_irradiance', voltage_column_list[n_mppt],
                              current_column_list[n_mppt]]]
                df_temp['mppt_id'] = current_column_list[n_mppt]
                df_temp['mppt_id'] = df_temp['mppt_id'].str.replace('current_', '')
                df_temp.rename(columns={voltage_column_list[n_mppt]: 'voltage_mppt',
                                        current_column_list[n_mppt]: 'current_mppt'}, inplace=True)
                if df_mppt.empty:
                    df_mppt = df_temp
                else:
                    df_mppt = pd.concat([df_mppt, df_temp], axis=0)
                    df_mppt.reset_index(drop=True, inplace=True)
            df_mppt.sort_values(['inv_id', 'mppt_id'], inplace=True)
            df_mppt.reset_index(drop=True, inplace=True)
            return df_mppt
        except Exception as e:
            logger.exception(f'Exception - {e}')

    @staticmethod
    def get_final_data(x_test, y_test, predictions):
        try:
            df_result = pd.DataFrame(index=[i for i in range(len(y_test))])
            df_result['datetime'] = x_test['datetime']
            df_result['actual_current_mppt'] = y_test
            df_result['predicted_current_mppt'] = predictions
            df_result['potential_current_mppt_loss'] = df_result['predicted_current_mppt'] - \
                                                       df_result['actual_current_mppt']
            df_result.loc[df_result['potential_current_mppt_loss'] < 0, 'potential_current_mppt_loss'] = 0
            df_result['hour'] = df_result['datetime'].dt.hour
            df_result.loc[df_result['hour'].between(left=18, right=23, inclusive='both'),
                          'potential_current_mppt_loss'] = 0
            df_result.loc[df_result['hour'].between(left=0, right=6, inclusive='both'),
                          'potential_current_mppt_loss'] = 0
            df_result.drop(['hour'], axis=1, inplace=True)
            df_result['total_potential_current_mppt_loss'] = df_result['potential_current_mppt_loss']. \
                rolling(min_periods=1, window=len(df_result)).sum()

            df_result.drop(['actual_current_mppt', 'predicted_current_mppt'], axis=1, inplace=True)
            df_result = df_result.round(2)
            df_result.reset_index(drop=True, inplace=True)
            logger.info(f'{df_result.shape}')
            return df_result
        except Exception as e:
            logger.exception(f'Exception - {e}')
