from loguru import logger
from scripts.core.data_puller_push.push_data import insert_values_3cp


class CalculatedDataPush:

    def __init__(self, df_calculated, all_cal_tags_dict):
        self.df_calculated = df_calculated
        self.all_cal_tags_dict = all_cal_tags_dict

    def kafka_data_push(self, df_calculated):
        try:
            logger.info(f"Calculated dict length = {len(self.all_cal_tags_dict)}")
            logger.info(f"Calculated df shape with Date and Timestamp column = {df_calculated.shape}")
            df_calculated_tags_dict = {col: self.all_cal_tags_dict[col] for col in df_calculated.columns
                                       if col not in ('Date', 'timestamp')}
            for i, j in df_calculated.iterrows():
                my_dict = {v: j[k] for k, v in df_calculated_tags_dict.items()}
                logger.info(f"{j['timestamp'], j['Date'], my_dict}")
                insert_values_3cp(j['timestamp'], my_dict)
        except Exception as e:
            logger.exception(f'Exception - {e}')
