from loguru import logger
import warnings
import pandas as pd
from scripts.utils.mongo_utils import MongoConnect
from scripts.constants.app_configuration import Mongo
from scripts.constants.app_constants import MongoConstants
warnings.filterwarnings('ignore')

base_folder = 'data_folder'


def get_coefficient(city):
    try:
        df_coefficient = pd.read_excel(f'{base_folder}/coefficient.xlsx', sheet_name=city)
        logger.info(f'shape of coefficient sheet for {city} - {df_coefficient.shape}')
        df_coefficient.set_index('inv_id_mppt_id', inplace=True)
        return df_coefficient
    except Exception as e:
        logger.exception(f'Exception - {e}')


def push_to_mongo(df, city):
    try:
        data_dict = df.to_dict(orient='index')
        mongo_conn = MongoConnect(uri=Mongo.mongo_uri, database=MongoConstants.db,
                                  collection=MongoConstants.collection)
        response = mongo_conn.insert_one(data=data_dict, city=city)
        logger.info(f'response - {response}')
    except Exception as e:
        logger.exception(f'Exception - {e}')