if __name__=="__main__":
    from dotenv import load_dotenv
    load_dotenv(dotenv_path="config.env")
from loguru import logger
import warnings
from scripts.core.coefficients import get_coefficient, push_to_mongo
warnings.filterwarnings('ignore')


def orchestrator(city):
    try:
        df_coefficients = get_coefficient(city=city)
        push_to_mongo(df=df_coefficients, city=city)
    except Exception as e:
        logger.exception(f'Exception - {e}')


if __name__ == "__main__":
    orchestrator(city='ariyalur')


