from loguru import logger
from scripts.core.data.data_import import DataPuller
from scripts.constants.app_configuration import KAIROS_DB_HOST, data_conf, training_data


def training_data_generator():
    logger.info("Fetching the training data!")
    training_data_puller = DataPuller(db_host=KAIROS_DB_HOST, data_config=data_conf, payload="train_query")
    logger.debug("Pulling the training data from Kairos")
    df_training_data = training_data_puller.get_data()
    logger.debug("Attempting to save the loaded data!")
    df_training_data.to_csv(training_data, index=False)
    logger.info("Training Data has been saved successfully!")


# if __name__ == '__main__':
#     # Create the training data!
#     training_data_generator()

