from loguru import logger
import pandas as pd


class ReadData:
    def __init__(self):
        self.sheet = "P2E Golden batch 05-01-2023.xlsx"
        self.base_path = f'data'

    def read_file(self, sheet_name, skip_rows=1):
        try:
            df = pd.read_excel(f'{self.base_path}/{self.sheet}', sheet_name=sheet_name,
                               skiprows=skip_rows)
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")

    def read_df(self):
        try:
            df_stage_1 = self.read_file(sheet_name="Stage I")
            df_stage_2 = self.read_file(sheet_name="Stage II")
            df_stage_3 = self.read_file(sheet_name="Stage III")
            df_stage_4 = self.read_file(sheet_name="Stage IV")
            df_stage_5 = self.read_file(sheet_name="Stage V")
            logger.debug(f'{df_stage_1.shape}, {df_stage_2.shape}, {df_stage_3.shape}, {df_stage_4.shape},'
                         f'{df_stage_5.shape},')
            return df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5
        except Exception as e:
            logger.exception(f"Exception - {e}")


