from dotenv import load_dotenv
import os
import sys
from configparser import ConfigParser, BasicInterpolation
import yaml
from loguru import logger

# Configuration File Constants
_application_conf = f"./conf/application.conf"
_default_conf = f"./config.env"
data_conf = f"./conf/data.yml"

load_dotenv(dotenv_path=_default_conf)


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(_application_conf)
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class Logging:
    level = config.get("LOGGING", "level", fallback="INFO")
    level = level if level else "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True


class Kafka:
    kairos_db_uri = config['KAIROS_DB']['uri']
    kafka_host = config["KAFKA"]["kafka_host"]
    kafka_port = config["KAFKA"]["kafka_port"]
    kafka_topic = config["KAFKA"]["kafka_topic"]


class PostgresCred:
    postgres_uri = config['POSTGRES_CRED']['postgres_uri']


class TimeZone:
    default_tz = config["TIMEZONE"]["default_tz"]
    required_tz = config["TIMEZONE"]["required_tz"]


# Read the configuration file
yml_file_path = "conf/"
try:
    with open(os.path.join(yml_file_path, 'data.yml'), 'r') as engine_yml_file:
        config_engine = yaml.full_load(engine_yml_file)
except Exception as e:
    logger.exception(f"Exception occurred - {e}", exc_info=True)

plants = config_engine["plants"]


