from loguru import logger
import warnings
from scripts.core.master_tables.batch_master_table import BatchMaster
from scripts.core.master_tables.batch_material_table import BatchMaterial
from scripts.core.master_tables.batch_kpi_table import BatchKpi
from scripts.core.join_tables.join_required_tables import JoinTables
warnings.filterwarnings('ignore')


if __name__ == "__main__":
    df_batch_master = BatchMaster().orchestrator_master()
    df_batch_kpi_master = BatchKpi().orchestrator_batch_kpi_master()
    df_batch_material_master = BatchMaterial().orchestrator_batch_material_master()
    JoinTables().join_master(df_batch_master=df_batch_master,
                             df_batch_kpi_master=df_batch_kpi_master,
                             df_batch_material_master=df_batch_material_master)
    logger.info('Module Completed')
