from typing import Any, Dict

from pydantic import BaseModel


class AzureDataModel(BaseModel):
    blob_name: str
    data: Any


class KafkaDataModel(BaseModel):
    data: Dict[str, Any]
    site_id: str
    gw_id: str = ''
    pd_id: str = ''
    timestamp: int
    msg_id: int = 0
    partition: str = ''
    retain_flag: bool = False
