from loguru import logger
import pandas as pd
from scripts.core.master_tables.dataframe_read import ReadData
from scripts.constants.app_configuration import PostgresCred


class BatchMaterial:
    def __init__(self):
        self.base_path = f'data'

    @staticmethod
    def batch_material_master(df, process_stage_name):
        try:
            df.rename(columns={'Batch  Number': 'batch_no', 'Start Time.1': 'batch_start_time',
                               'End Time.1': 'batch_end_time', 'Downtime': 'downtime',
                               'Equipment': 'used_equipment'}, inplace=True)
            df_stage = pd.DataFrame(index=[i for i in range(len(df))])
            if process_stage_name == "Stage-01":
                df_stage['batch_no'] = df['batch_no']
                df_stage['input_qty'] = df['Input Qty. (kg) F00056-BULK-001']
                df_stage['input_qty_uom'] = 'kg'
                df_stage['output_qty'] = df['Output Qty. (kg)']
                df_stage['output_qty_uom'] = 'kg'

            elif process_stage_name == "Stage-02":
                df_stage['batch_no'] = df['batch_no']
                df_stage['input_qty'] = df['Input Qty.\n(kg) Stage-I']
                df_stage['input_qty_uom'] = 'kg'
                df_stage['output_qty'] = df['Output \nQty. (kg)']
                df_stage['output_qty_uom'] = 'kg'

            elif process_stage_name == "Stage-03":
                df_stage['batch_no'] = df['batch_no']
                df_stage['input_qty'] = df['Input Qty. (kg) Stage-I']
                df_stage['input_qty_uom'] = 'kg'
                df_stage['output_qty'] = df['Output Qty. (kg)']
                df_stage['output_qty_uom'] = 'kg'

            elif process_stage_name == "Stage-04":
                df_stage['batch_no'] = df['batch_no']
                df_stage['input_qty'] = df['Input Qty. (kg)\n/Stage-I']
                df_stage['input_qty_uom'] = 'kg'
                df_stage['output_qty'] = df['Output \nQty. (kg)']
                df_stage['output_qty_uom'] = 'kg'

            elif process_stage_name == "Stage-05":
                df_stage['batch_no'] = df['batch_no']
                df_stage['input_qty'] = df['Input \nQty. Kg\nStage-I']
                df_stage['input_qty_uom'] = 'kg'
                df_stage['output_qty'] = df['Output \nQty. (kg)']
                df_stage['output_qty_uom'] = 'kg'

            df_stage.reset_index(drop=True, inplace=True)
            df_stage = df_stage[['batch_no', 'input_qty', 'input_qty_uom', 'output_qty', 'output_qty_uom']]

            return df_stage
        except Exception as e:
            logger.exception(f"Exception - {e}")

    def orchestrator_batch_material_master(self):
        try:
            df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5 = ReadData().read_df()
            df_stage_1 = self.batch_material_master(df_stage_1, process_stage_name="Stage-01")
            df_stage_2 = self.batch_material_master(df_stage_2, process_stage_name="Stage-02")
            df_stage_3 = self.batch_material_master(df_stage_3, process_stage_name="Stage-03")
            df_stage_4 = self.batch_material_master(df_stage_4, process_stage_name="Stage-04")
            df_stage_5 = self.batch_material_master(df_stage_5, process_stage_name="Stage-05")

            df = pd.concat([df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5], axis=0)
            df.reset_index(drop=True, inplace=True)
            df = df[['batch_no', 'input_qty', 'input_qty_uom', 'output_qty', 'output_qty_uom']]
            df = df.round(2)
            df.to_excel(f"{self.base_path}/t_batch_material_master.xlsx", index=False)
            logger.info(f'Pushing batch_master to postgres')
            df.set_index('batch_no').to_sql("t_batch_material_master", PostgresCred.postgres_uri, if_exists="replace")
            logger.debug(f'Pushed batch_master to postgres')
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")