from loguru import logger
import pandas as pd
from scripts.core.master_tables.dataframe_read import ReadData
from scripts.constants.app_configuration import PostgresCred


class BatchMaster:
    def __init__(self):
        self.base_path = f'data'

    @staticmethod
    def batch_master(df, process_stage_name, batch_product, ideal_batch_cycle_time_hr, batch_setup_time_hr,
                     process_stage_id, work_order_no="P2E-STD-01", work_order_item_no="P2E-STD-01-01",
                     final_product="P2E"):
        try:

            df = df[['Batch  Number', 'Start Time.1', 'End Time.1', 'Downtime', 'Equipment']]
            df.rename(columns={'Batch  Number': 'batch_no', 'Start Time.1': 'batch_start_time',
                               'End Time.1': 'batch_end_time', 'Downtime': 'downtime',
                               'Equipment': 'used_equipment'}, inplace=True)
            df['live_batch_end_time'] = None
            df['process_stage_name'] = process_stage_name
            df['process_stage_id'] = process_stage_id
            df['work_order_no'] = work_order_no
            df['work_order_item_no'] = work_order_item_no
            df['final_product'] = final_product
            df['batch_product'] = batch_product
            df['ideal_batch_cycle_time_hr'] = ideal_batch_cycle_time_hr
            df['batch_cycle_time'] = df['batch_end_time'] - df['batch_start_time']
            df['batch_cycle_time_minutes'] = df['batch_cycle_time'].dt.total_seconds() // 60
            df['batch_setup_time_hr'] = batch_setup_time_hr
            df['selected_equipments'] = df['used_equipment']
            df['created_on'] = df['batch_start_time'].dt.date
            df['created_by'] = 'Aakash'
            df['last_updated_on'] = df['batch_end_time'].dt.date
            df['last_updated_by'] = 'Aakash'
            df['golden_batch'] = None
            df = df.astype({'batch_cycle_time': str})

            df = df[['batch_no', 'final_product', 'batch_product', 'process_stage_name', 'process_stage_id',
                     'work_order_no', 'work_order_item_no', 'ideal_batch_cycle_time_hr', 'batch_start_time',
                     'batch_end_time', 'live_batch_end_time', 'batch_cycle_time', 'batch_cycle_time_minutes',
                     'batch_setup_time_hr', 'downtime', 'selected_equipments', 'created_on', 'created_by',
                     'last_updated_on', 'last_updated_by', 'golden_batch']]
            df.reset_index(drop=True, inplace=True)
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")

    def orchestrator_master(self):
        try:
            df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5 = ReadData().read_df()
            df_stage_1 = self.batch_master(df_stage_1, process_stage_name="Stage-01",
                                           process_stage_id="P2E-STAGE-001",
                                           batch_product="P2E-Stage-01", ideal_batch_cycle_time_hr=12,
                                           batch_setup_time_hr=1)
            df_stage_2 = self.batch_master(df_stage_2, process_stage_name="Stage-02",
                                           process_stage_id="P2E-STAGE-002",
                                           batch_product="P2E-Stage-02", ideal_batch_cycle_time_hr=24,
                                           batch_setup_time_hr=1)
            df_stage_3 = self.batch_master(df_stage_3, process_stage_name="Stage-03",
                                           process_stage_id="P2E-STAGE-003",
                                           batch_product="P2E-Stage-03", ideal_batch_cycle_time_hr=48,
                                           batch_setup_time_hr=1)
            df_stage_4 = self.batch_master(df_stage_4, process_stage_name="Stage-04",
                                           process_stage_id="P2E-STAGE-004",
                                           batch_product="P2E-Stage-04", ideal_batch_cycle_time_hr=124,
                                           batch_setup_time_hr=1)
            df_stage_5 = self.batch_master(df_stage_5, process_stage_name="Stage-05",
                                           process_stage_id="P2E-STAGE-005",
                                           batch_product="P2E-Stage-05", ideal_batch_cycle_time_hr=110,
                                           batch_setup_time_hr=1)

            df = pd.concat([df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5], axis=0)
            df.reset_index(drop=True, inplace=True)

            df = df.astype({'ideal_batch_cycle_time_hr': float})
            df = df.round(2)
            df.to_excel(f"{self.base_path}/t_batch_master.xlsx", index=False)
            logger.info(f'Pushing batch_master to postgres')
            df.set_index('batch_no').to_sql("t_batch_master", PostgresCred.postgres_uri, if_exists="replace")

            logger.debug(f'Pushed batch_master to postgres')
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")
