from loguru import logger
import pandas as pd
from scripts.core.master_tables.dataframe_read import ReadData


class BatchKpi:
    def __init__(self):
        self.base_path = f'data'

    @staticmethod
    def batch_kpi_master(df, process_stage_name, process_stage_id):
        try:
            df.rename(columns={'Batch  Number': 'batch_no', 'Start Time.1': 'batch_start_time',
                               'End Time.1': 'batch_end_time', 'Quality': 'quality'}, inplace=True)
            df['process_stage_name'] = process_stage_name
            df['process_stage_id'] = process_stage_id

            if process_stage_name == "Stage-01":
                df['formaldehyde_content'] = df['F00041-BULK-001 content nil']
                df['unreactive_alpha_picoline'] = df['un reacted F00056-BULK-001 ( for infor.)']
                df['moisture_content'] = df['Moisture content \n(for infor)']

            elif process_stage_name == "Stage-02":
                df['formaldehyde_content'] = None
                df['unreactive_alpha_picoline'] = df['F00056-BULK-001 \n(NLT 50 %)']
                df['moisture_content'] = df['Moisture content \n(for Information).1']

            elif process_stage_name == "Stage-03":
                df['formaldehyde_content'] = None
                df['unreactive_alpha_picoline'] = None
                df['moisture_content'] = df['M/C for infor']

            elif process_stage_name == "Stage-04":
                df['formaldehyde_content'] = None
                df['unreactive_alpha_picoline'] = None
                df['moisture_content'] = df['NMT 0.5%']

            elif process_stage_name == "Stage-05":
                df['formaldehyde_content'] = None
                df['unreactive_alpha_picoline'] = None
                df['moisture_content'] = df[' NMT 1.0%']

            df = df[['batch_no', 'quality', 'formaldehyde_content', 'unreactive_alpha_picoline',
                     'moisture_content']]
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")

    def orchestrator_batch_kpi_master(self):
        try:
            df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5 = ReadData().read_df()
            df_stage_1 = self.batch_kpi_master(df_stage_1, process_stage_name="Stage-01",
                                               process_stage_id="P2E-STAGE-001")
            df_stage_2 = self.batch_kpi_master(df_stage_2, process_stage_name="Stage-02",
                                               process_stage_id="P2E-STAGE-002")
            df_stage_3 = self.batch_kpi_master(df_stage_3, process_stage_name="Stage-03",
                                               process_stage_id="P2E-STAGE-003")
            df_stage_4 = self.batch_kpi_master(df_stage_4, process_stage_name="Stage-04",
                                               process_stage_id="P2E-STAGE-004")
            df_stage_5 = self.batch_kpi_master(df_stage_5, process_stage_name="Stage-05",
                                               process_stage_id="P2E-STAGE-005")

            df = pd.concat([df_stage_1, df_stage_2, df_stage_3, df_stage_4, df_stage_5], axis=0)
            df = df[['batch_no', 'quality', 'formaldehyde_content', 'unreactive_alpha_picoline', 'moisture_content']]
            df.reset_index(drop=True, inplace=True)
            df = df.round(2)
            df.to_excel(f"{self.base_path}/t_batch_kpi_master.xlsx", index=False)
            logger.info(f'Pushing batch_kpi_master to postgres')
            df.set_index('batch_no').to_sql("t_batch_kpi_master",
                                            "postgresql://ilens:iLens$456@192.168.0.207:5455/ilens_ai",
                                            if_exists="replace")
            logger.debug(f'Pushed batch_kpi_master to postgres')
            return df
        except Exception as e:
            logger.exception(f"Exception - {e}")
