from loguru import logger
import pandas as pd
from scripts.core.master_tables.dataframe_read import ReadData


class JoinTables:
    def __init__(self):
        self.base_path = f'data'

    def join_master(self, df_batch_master, df_batch_kpi_master, df_batch_material_master):
        try:
            df_kpi_join = pd.merge(left=df_batch_master, right=df_batch_kpi_master, how='left', on='batch_no')
            df = pd.merge(left=df_kpi_join, right=df_batch_material_master, how='left', on='batch_no')
            df['bct_input_qty_ratio'] = df['batch_cycle_time_minutes'] / df['input_qty']

            min_bct_1 = df.loc[df['process_stage_id'] == 'P2E-STAGE-001', 'batch_cycle_time_minutes'].min()
            min_bct_2 = df.loc[df['process_stage_id'] == 'P2E-STAGE-002', 'batch_cycle_time_minutes'].min()
            min_bct_3 = df.loc[df['process_stage_id'] == 'P2E-STAGE-003', 'batch_cycle_time_minutes'].min()
            min_bct_4 = df.loc[df['process_stage_id'] == 'P2E-STAGE-004', 'batch_cycle_time_minutes'].min()
            min_bct_5 = df.loc[df['process_stage_id'] == 'P2E-STAGE-005', 'batch_cycle_time_minutes'].min()
            df.loc[(df['process_stage_id'] == 'P2E-STAGE-001') & (df['batch_cycle_time_minutes'] == min_bct_1),
                   'golden_batch'] = 'Golden Batch'
            df.loc[(df['process_stage_id'] == 'P2E-STAGE-002') & (df['batch_cycle_time_minutes'] == min_bct_2),
                   'golden_batch'] = 'Golden Batch'
            df.loc[(df['process_stage_id'] == 'P2E-STAGE-003') & (df['batch_cycle_time_minutes'] == min_bct_3),
                   'golden_batch'] = 'Golden Batch'
            df.loc[(df['process_stage_id'] == 'P2E-STAGE-004') & (df['batch_cycle_time_minutes'] == min_bct_4),
                   'golden_batch'] = 'Golden Batch'
            df.loc[(df['process_stage_id'] == 'P2E-STAGE-005') & (df['batch_cycle_time_minutes'] == min_bct_5),
                   'golden_batch'] = 'Golden Batch'
            df.reset_index(drop=True, inplace=True)
            df = df.round(2)
            df.to_excel(f"{self.base_path}/t_batch_information_master.xlsx", index=False)
            logger.info(f'Pushing master_join to postgres')
            df.set_index('batch_no').to_sql("t_batch_information_master",
                                            "postgresql://ilens:iLens$456@192.168.0.207:5455/ilens_ai",
                                            if_exists='replace')
            logger.debug(f'Pushed master_join to postgres')
        except Exception as e:
            logger.exception(f"Exception - {e}")