import numpy as np
import warnings
warnings.filterwarnings("ignore")
import traceback
import xlsxwriter
from scripts.logging import logger
import pandas as pd
from datetime import datetime, timedelta
from scripts.utils.yield_sheet_3cp_utils.all_tags_3cp import TagsDict
enable_traceback = True
from scripts.utils.yield_sheet_3cp_utils.manual_dcs_dataframe import AllTagsDataPuller, get_dataframe
from scripts.utils.yield_sheet_3cp_utils.reorder_renaming_ebpr import ReorderRename


class ReportGenerator:
    def __init__(self, tags_cal, tags_cal_prev, tags_manual, tags_dcs, start_date, end_date):
        self.tags_cal = tags_cal
        self.tags_cal_prev = tags_cal_prev
        self.tags_manual = tags_manual
        self.tags_dcs = tags_dcs
        self.start_date = start_date - timedelta(days=1)
        self.end_date = end_date

    def yield_report_3cp(self):
        try:

            all_manual_dcs_tags_dict, all_cal_tags_dict = TagsDict().all_tags(self.tags_cal, self.tags_cal_prev,
                                                                              self.tags_manual, self.tags_dcs)
            all_tags_dict = {**all_manual_dcs_tags_dict, **all_cal_tags_dict}
            all_tags = list(all_tags_dict.values())

            all_tags_data_puller = AllTagsDataPuller(start_date=self.start_date, end_date=self.end_date)
            manual_dcs_input = all_tags_data_puller.get_kairos_data(tags_dict=all_tags_dict,
                                                                    tags_lst=all_tags)

            df = get_dataframe(date_dict=manual_dcs_input, tags_lst=list(all_tags_dict.keys()))
            logger.info(f'')

            for col in [col for col in list(df.columns) if col not in ('Date',
                                                                       'Utility_report_Power_Norms',
                                                                       'Utility_report_Steam_Norms',
                                                                       'Utility_report_Raffinate_Norms',
                                                                       'Utility_report_Raffinate_Vent_Gas',
                                                                       'Utility_report_Raw_Water_Norms',
                                                                       'Utility_report_Actual_Ammonia_Norms',
                                                                       'Utility_report_Actual_Beta_Norms',
                                                                       'Utility_report_Day_DM_norm',
                                                                       'Utility_report_Actual_Benzene_Norms')]:
                df.loc['Total', col] = df[col].sum()

            df['Date'][-1] = 'Total'
            average_list = []
            for col in [col for col in list(df.columns) if col in ('Utility_report_Power_Norms',
                                                                   'Utility_report_Steam_Norms',
                                                                   'Utility_report_Raffinate_Norms',
                                                                   'Utility_report_Raffinate_Vent_Gas',
                                                                   'Utility_report_Raw_Water_Norms',
                                                                   'Utility_report_Actual_Ammonia_Norms',
                                                                   'Utility_report_Actual_Beta_Norms',
                                                                   'Utility_report_Day_DM_norm',
                                                                   'Utility_report_Actual_Benzene_Norms')]:
                df.loc['Average', col] = df[col].mean()

            df['Date'][-1] = 'Average'
            df = df.round(3)

            df_concat = ReorderRename(df_ebpr=df).reorder_rename()
            df_concat.replace({'inf': 'nan'}, inplace=True)

            return df, df_concat, f"Report is ready"
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)
            return None, f"Error - {e}"


def get_dpr_report_format(df):
    try:
        df_format = df.copy()
        df_format = df_format.drop(['Total', 'Average'])
        df_format['Date'] = pd.to_datetime(df_format['Date'])
        df_format['month'] = df_format['Date'].dt.month
        df_format['day'] = df_format['Date'].dt.day

        last_date = df_format.iloc[-1, df_format.columns.get_loc('Date')].date()

        latest_month = max(list(df_format['month'].unique()))
        df_format = df_format[df_format['month'] == latest_month]
        df_format.reset_index(drop=True, inplace=True)
        latest_day = max(list(df_format['day'].unique()))

        data_0 = [[last_date, last_date, last_date, last_date, last_date,
                   last_date, last_date, last_date, last_date, last_date]]

        data_1 = [['Production', 'UOM', "Month's opening", "Day Production", "To date Production",
                   "Day Nia Transfer", "To date Nia Transfer", "Day 3CP Drum Filling Dispatch",
                   "To Date 3CP Drum Filling Dispatch", "Closing Stock"],

                  ["Pure 3CP", "MT",
                   df_format[df_format['day'] == 1]['Pure_Production_Opening_DPR'].values[0],
                   df_format[df_format['day'] == latest_day]['Pure_Production_Day_Prod_DPR'].values[0],
                   df_format[df_format['day'] == latest_day]['Pure_Production_Total_Prod_DPR'].values[0],
                   df_format[df_format['day'] == latest_day]['Pure_Production_Day_Nia_DPR'].values[0],
                   df_format[df_format['day'] == latest_day]['Pure_Production_Total_Nia_DPR'].values[0], None, None,
                   df_format[df_format['day'] == latest_day]['Pure_Production_Closing_of_Pure_Tanks_only_DPR'].values[0]],
                  ['Crude 3CP', 'MT', None,
                   df_format[df_format['day'] == latest_day]['Crude_Prod_Day_Prod_DPR'].values[0],
                   df_format[df_format['day'] == latest_day]['Crude_Prod_Total_Prod_DPR'].values[0],
                   None, None, None, None, None]]

        data_2 = [
            ['ITEM CODE', 'Raw Material', 'UOM', "Month's Opening", 'Day Opening Stock', 'Day Receipt',
             'To Date Receipt', 'Day Consumption', 'To Date Consumption', 'Closing Stock'],

            ['F00040-BULK-0001', 'Beta Picoline', 'MT',
             df_format[df_format['day'] == 1]['D1D001_consumptions_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Day_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Total_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['Crude_Prod_Day_Prod_DPR'].values[0]*1.04,
             df_format[df_format['day'] == 1]['D1D001_consumptions_Opening_DPR'].values[0] +
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Total_Receipt_DPR'].values[0] -
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Closing_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Closing_DPR'].values[0]
             ],
            ['7302011030', 'Ammonia', 'MT',
             df_format[df_format['day'] == 1]['7302011030_Consumptions_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011030_Consumptions_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['D1D001_consumptions_Day_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011030_Consumptions_Total_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011030_Consumptions_Day_Cons_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011030_Consumptions_Total_Cons_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011030_Consumptions_Closing_DPR'].values[0]
             ],

            ['7302011061', 'Benzene', 'MT',
             df_format[df_format['day'] == 1]['7302011061_Consumption_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Opening_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Day_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Total_Receipt_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Day_Cons_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Total_Cons_DPR'].values[0],
             df_format[df_format['day'] == latest_day]['7302011061_Consumption_Closing_DPR'].values[0]
             ]
        ]
        final_lst = data_0 + data_1 + data_2
        df_report_format = pd.DataFrame(final_lst)
        return df_report_format, last_date
    except Exception as e:
        logger.exception(f'Exception - {e}')


def get_dpr(master_output_file, df, df_format):
    try:
        writer = pd.ExcelWriter(master_output_file, engine='xlsxwriter')
        df.to_excel(writer, sheet_name="DPR Sheet", index=True)
        df_report_format, last_date = get_dpr_report_format(df=df_format)
        df_report_format.to_excel(writer, sheet_name="Report Format", index=False)
        workbook = writer.book
        _format = workbook.add_format(
            {'font_name': 'Trebuchet MS', 'text_wrap': True, 'bold': 2, 'font_color': "blue"})
        _format.set_align('center')
        _format.set_align('vcenter')
        format1 = workbook.add_format({'font_name': 'Trebuchet MS', 'text_wrap': True})
        format1.set_align('center')
        format1.set_align('vcenter')
        header_footer_format = workbook.add_format({
            'text_wrap': True
        })

        no_of_rows = df.shape[0]
        worksheet = writer.sheets["DPR Sheet"]
        # set the column width as per your requirement
        worksheet.set_column('A:A', 25, _format)
        worksheet.set_column('B:F', 15, _format)
        worksheet.set_column('G:L', 20, _format)
        worksheet.set_column('N:T', 22, _format)
        worksheet.set_column('U:Z', 22, _format)
        worksheet.set_column('AB:AD', 20, _format)
        worksheet.set_column('AE:AM', 22, _format)
        worksheet.set_column('AN:AO', 29, _format)
        worksheet.set_column('AQ:AU', 27, _format)
        worksheet.set_column('AV:BC', 33, _format)
        worksheet.set_column('BD:BD', 30, _format)
        worksheet.set_column('BE:BH', 27, _format)
        worksheet.set_column('AY:AY', 40, _format)
        worksheet.set_column('BA:BA', 35, _format)

        worksheet.set_column('M:M', 10, _format)
        worksheet.set_column('T:T', 10, _format)
        worksheet.set_column('AD:AD', 10, _format)
        worksheet.set_column('AP:AP', 10, _format)
        worksheet.set_column('BK:BK', 10, _format)
        worksheet.set_column('AA:AA', 10, _format)
        worksheet.set_column('AT:AT', 30, _format)
        worksheet.set_column('BA:BA', 25, _format)

        format4 = workbook.add_format({'bg_color': 'yellow'})
        format5 = workbook.add_format({'text_wrap': True})

        worksheet.set_row(0, 28, format5)
        worksheet.conditional_format(f'A{no_of_rows + 2}:AP{no_of_rows + 2}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})
        worksheet.conditional_format(f'AV{no_of_rows + 2}:AZ{no_of_rows + 2}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})
        worksheet.conditional_format(f'BB{no_of_rows + 2}:BD{no_of_rows + 2}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})

        worksheet.conditional_format(f'AQ{no_of_rows + 3}:AU{no_of_rows + 3}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})
        worksheet.conditional_format(f'BA{no_of_rows + 3}:BA{no_of_rows + 3}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})
        worksheet.conditional_format(f'BE{no_of_rows + 3}:BG{no_of_rows + 3}',
                                     {'type': 'cell', 'criteria': '<=', 'value': 10000000, 'format': format4})

        border_fmt = workbook.add_format({'bottom': 2, 'top': 2, 'left': 2, 'right': 2})
        worksheet.conditional_format(xlsxwriter.utility.xl_range(0, 0, df_format.shape[0]+4, 58),
                                            {'type': 'no_errors', 'format': border_fmt})

        _format1 = workbook.add_format(
            {'font_name': 'Trebuchet MS', 'text_wrap': True, 'bold': 2, 'font_color': "black"})
        _format1.set_align('center')
        _format1.set_align('vcenter')

        header_footer_format = workbook.add_format({
            'text_wrap': True
        })
        no_of_rows_format = df_report_format.shape[0]
        worksheet_format = writer.sheets["Report Format"]
        worksheet_format.set_column('A:J', 15, _format1)

        cell_format = workbook.add_format({'align': 'center', 'valign': 'vcenter', 'border': 1, 'bold': True,
                                           'text_wrap': True})
        worksheet_format.merge_range('A1:J2', str(last_date), cell_format)

        cell_format_headings = workbook.add_format({'align': 'center', 'valign': 'vcenter',
                                                    'bold': True, 'text_wrap': True, 'font_color': 'black'})
        worksheet_format.set_row(2, 15, cell_format_headings)
        worksheet_format.set_row(5, 15, cell_format_headings)

        cell_format_content = workbook.add_format({'align': 'center', 'valign': 'vcenter',
                                                    'bold': True, 'text_wrap': True, 'font_color': 'blue'})
        worksheet_format.set_row(3, 13, cell_format_content)
        worksheet_format.set_row(4, 13, cell_format_content)
        worksheet_format.set_row(6, 13, cell_format_content)
        worksheet_format.set_row(7, 13, cell_format_content)
        worksheet_format.set_row(8, 13, cell_format_content)

        border_fmt = workbook.add_format({'bottom': 2, 'top': 2, 'left': 2, 'right': 2})
        worksheet_format.conditional_format(xlsxwriter.utility.xl_range(0, 0, 8, 9),
                                     {'type': 'no_errors', 'format': border_fmt})
        writer.save()

        writer.save()

        if not master_output_file.endswith('.xlsx'):
            master_output_file = master_output_file + '.xlsx'
        return master_output_file
    except Exception as e:
        logger.exception(f'Exception - {e}')
