import pandas as pd
from datetime import datetime, timedelta
from loguru import logger


class EbprManualDcsDataframe:
    def __init__(self, date_output, all_manual_dcs_tags):
        self.date_output=date_output
        self.all_manual_dcs_tags=all_manual_dcs_tags
    def ebpr_manual_dcs_dataframe(self):
        try:
            date_output_filtered = self.date_output
            # date_output_filtered = {k: v for k, v in date_output_filtered.items() if len(v) == len(self.all_manual_dcs_tags)}
            columns_tags = list(list(date_output_filtered.values())[0].keys())
            value_list = [list(dic.values()) for dic in list(date_output_filtered.values())]
            df_manual_dcs = pd.DataFrame(columns=columns_tags, data=value_list)
            # df_manual_dcs = df_manual_dcs.round(decimals=3)
            df_manual_dcs_dates = list(date_output_filtered.keys())
            date_list = [list(date_output_filtered.keys())[0] + timedelta(days=x) \
                                     for x in range((list(date_output_filtered.keys())[-1] -
                                                     list(date_output_filtered.keys())[0]).days + 1)]
            date_list1 = list(date_output_filtered.keys())
            df_manual_dcs["Date"] = date_list1
            # df_manual_dcs.drop(['Beta_Purification_Column_C_2409_Outlet_Flow_TZ'], axis=1, inplace=True)
            df_manual_dcs_ebpr = df_manual_dcs.copy()

            # shift column 'Name' to first position
            first_column = df_manual_dcs_ebpr.pop('Date')

            # insert column using insert(position,column_name,
            # first_column) function
            df_manual_dcs_ebpr.insert(0, 'Date', first_column)
            logger.debug(f"Dataframe shape of Manual and dcs tags = {df_manual_dcs.shape}")
            logger.info(f"No of rows containing NaN values in manual and dcs data = "
                        f"{df_manual_dcs[df_manual_dcs.isnull().any(axis=1)].shape[0]}")
            null_col_manual_list = [col for col in df_manual_dcs.columns if df_manual_dcs[col].isnull().any()]
            logger.info(f"Columns containing NaN values in manual and dcs data = {null_col_manual_list}")
            return df_manual_dcs, df_manual_dcs_ebpr, date_output_filtered
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)

