import pandas as pd
from loguru import logger
enable_traceback = True


class CalculationCalculatedColumns:
  def __init__(self):
    pass

  def summation(self, tag_list):
    return sum(tag_list)

  def subtract(self, first_ele, second_ele):
    return (first_ele - second_ele)

  def division(self, first_ele, second_ele):
    return (first_ele / second_ele)

  def calculations(self, df_manual_dcs, df_calculated):
    logger.info(f"Calculated data for 3CP")
    try:
      for rows in range(1, df_manual_dcs.shape[0]):
        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Opening_DPR"] = \
          df_calculated.loc[df_calculated.index[rows - 1], "D1D001_consumptions_Closing_DPR"]

        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Total_Receipt_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "D1D001_consumptions_Total_Receipt_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], 'D1D001_consumptions_Day_Receipt_DPR']])

        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Closing_DPR"] = \
          (self.summation(
            [((self.summation([df_manual_dcs.loc[df_calculated.index[rows], 'D1D001Readings_T_2703_A_DPR'], \
                               df_manual_dcs.loc[
                                 df_calculated.index[rows], 'D1D001Readings_T_2703_B_DPR']]) + 30) * 331.8 * 0.95), \
             (self.summation([df_manual_dcs.loc[df_calculated.index[rows], 'D1D001Readings_T_2101_A_DPR'], \
                              df_manual_dcs.loc[df_calculated.index[rows], 'D1D001Readings_T_2101_B_DPR']])) * 459]) + \
           (30 * 101.8 * 0.95)) / 1000

        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Day_Recovery_DPR"] = \
            self.subtract(df_manual_dcs.loc[df_calculated.index[rows],
                                            'Beta_Purification_Column_C_2409_Outlet_Flow_TZ'],
                          df_manual_dcs.loc[df_calculated.index[rows - 1],
                                            'Beta_Purification_Column_C_2409_Outlet_Flow_TZ'],
                          )

        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Day_Cons_DPR"] = \
          self.subtract(self.summation([df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Opening_DPR"], \
                                        df_manual_dcs.loc[
                                          df_calculated.index[rows], 'D1D001_consumptions_Day_Receipt_DPR'], \
                                        df_calculated.loc[
                                          df_calculated.index[rows], 'D1D001_consumptions_Day_Recovery_DPR']]), \
                        df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Closing_DPR"])

        df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Opening_DPR"] = \
          df_manual_dcs.loc[df_calculated.index[rows - 1], '7302011030_Consumptions_Closing_DPR']

        df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Day_Cons_DPR"] = \
          self.subtract(
            self.summation([df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Opening_DPR"], \
                            df_manual_dcs.loc[df_calculated.index[rows], '7302011030_Consumptions_Day_Receipt_DPR']]), \
            df_manual_dcs.loc[df_calculated.index[rows], '7302011030_Consumptions_Closing_DPR'])

        df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Total_Cons_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "7302011030_Consumptions_Total_Cons_DPR"], \
                          df_calculated.loc[df_calculated.index[rows], '7302011030_Consumptions_Day_Cons_DPR']])

        df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Total_Receipt_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "7302011030_Consumptions_Total_Receipt_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], '7302011030_Consumptions_Day_Receipt_DPR']])

        df_calculated.loc[df_calculated.index[rows], "7302011061_Consumption_Opening_DPR"] = \
          df_calculated.loc[df_calculated.index[rows - 1], "7302011061_Consumption_Closing_DPR"]

        df_calculated.loc[df_calculated.index[rows], "7302011061_Consumption_Closing_DPR"] = \
          self.subtract(
            self.summation([df_calculated.loc[df_calculated.index[rows], "7302011061_Consumption_Opening_DPR"], \
                            df_manual_dcs.loc[df_calculated.index[rows], '7302011061_Consumption_Day_Receipt_DPR']]), \
            df_manual_dcs.loc[df_calculated.index[rows], '7302011061_Consumption_Day_Cons_DPR'])

        df_calculated.loc[df_calculated.index[rows], "7302011061_Consumption_Total_Cons_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "7302011061_Consumption_Total_Cons_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], '7302011061_Consumption_Day_Cons_DPR']])

        df_calculated.loc[df_calculated.index[rows], "7302011061_Consumption_Total_Receipt_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "7302011061_Consumption_Total_Receipt_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], '7302011061_Consumption_Day_Receipt_DPR']])


        df_calculated.loc[df_calculated.index[rows], "Crude_Prod_Day_Prod_DPR"] = \
          df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Day_Cons_DPR"] * \
          df_manual_dcs.loc[df_calculated.index[rows], 'D1D001Readings_Conv_DPR']

        df_calculated.loc[df_calculated.index[rows], "Crude_Prod_Total_Prod_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "Crude_Prod_Total_Prod_DPR"], \
                          df_calculated.loc[df_calculated.index[rows], 'Crude_Prod_Day_Prod_DPR']])

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Opening_DPR"] = \
          df_calculated.loc[df_calculated.index[rows - 1], "Pure_Production_Closing_of_Pure_Tanks_only_DPR"]

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Closing_of_Pure_Tanks_only_DPR"] = \
          self.summation(
            [((self.summation([df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_LT_2701_A_DPR'], \
                               df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_LT_2701_B_DPR']])) * 1.08), \
             df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_Pure_tank_Dead_Volumes_DPR']])

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Total_Nia_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "Pure_Production_Total_Nia_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_Day_Nia_DPR']])

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Total_Drum_Filling_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "Pure_Production_Total_Drum_Filling_DPR"], \
                          df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_Day_Drum_Filling_DPR']])

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Day_Prod_DPR"] = \
          self.subtract(self.summation(
            [df_calculated.loc[df_calculated.index[rows], "Pure_Production_Closing_of_Pure_Tanks_only_DPR"], \
             df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_Day_Nia_DPR'], \
             df_manual_dcs.loc[df_calculated.index[rows], 'Pure_Production_Day_Drum_Filling_DPR']]), \
                        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Opening_DPR"])

        df_calculated.loc[df_calculated.index[rows], "Pure_Production_Total_Prod_DPR"] = \
          self.summation([df_calculated.loc[df_calculated.index[rows - 1], "Pure_Production_Total_Prod_DPR"], \
                          df_calculated.loc[df_calculated.index[rows], 'Pure_Production_Day_Prod_DPR']])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Day_Prod"] = \
          df_calculated.loc[df_calculated.index[rows], "Crude_Prod_Day_Prod_DPR"]

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Power_Norms"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Day_Power'], \
                        df_calculated.loc[df_calculated.index[rows], 'Utility_report_Actual_Day_Prod'])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Steam_Norms"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Day_Steam'], \
                        df_calculated.loc[df_calculated.index[rows], 'Utility_report_Actual_Day_Prod'])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Raffinate_Norms"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Day_Raffinate'], \
                        df_calculated.loc[df_calculated.index[rows], 'Utility_report_Actual_Day_Prod'])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Raffinate_Vent_Gas"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Vent_Gas_Raffinate'], \
                        df_calculated.loc[df_calculated.index[rows], 'Utility_report_Actual_Day_Prod'])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Raw_Water_Norms"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Day_Treated_Water'], \
                        df_calculated.loc[df_calculated.index[rows], 'Utility_report_Actual_Day_Prod'])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_per_hr_burn_rate"] = \
          df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Raffinate_Incinerated'] * 1000 / 24

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Ammonia_Norms"] = \
          self.division(df_calculated.loc[df_calculated.index[rows], "7302011030_Consumptions_Day_Cons_DPR"], \
                        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Day_Prod"])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Beta_Norms"] = \
          self.division(self.subtract(df_calculated.loc[df_calculated.index[rows], "D1D001_consumptions_Day_Cons_DPR"], \
                                      df_calculated.loc[
                                        df_calculated.index[rows], "D1D001_consumptions_Day_Recovery_DPR"]), \
                        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Day_Prod"])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Benzene_Norms"] = \
          self.division(df_manual_dcs.loc[df_calculated.index[rows], '7302011061_Consumption_Day_Cons_DPR'], \
                        df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Day_Prod"])

        df_calculated.loc[df_calculated.index[rows], "Utility_report_Day_DM_norm"] = \
            self.division(df_manual_dcs.loc[df_calculated.index[rows], 'Utility_report_Day_DM'], \
                          df_calculated.loc[df_calculated.index[rows], "Utility_report_Actual_Day_Prod"])

      return df_calculated
    except Exception as e:
      logger.exception("Exception occurred", exc_info=True)
