import pandas as pd
from datetime import datetime, timedelta
from loguru import logger
from scripts.utils.yield_sheet_3cp_utils.data_puller_3cp import Kairos_query
from scripts.utils.yield_sheet_3cp_utils.data_calculator import CalculationCalculatedColumns


class CalculatedDataframe:
    def __init__(self, date_output_filtered, all_calculated_tags, all_cal_tags_dict, df_manual_dcs):
        self.date_output_filtered=date_output_filtered
        self.all_calculated_tags=all_calculated_tags
        self.all_cal_tags_dict=all_cal_tags_dict
        self.df_manual_dcs=df_manual_dcs

    def unavailable_cal_tags(self, date_output_calculated):
        try:
            unavailable_tags_cal = {}
            for k, v in date_output_calculated.items():
                if len(v) != len(self.all_calculated_tags):
                    required_tags_cal = [tags for tags in list(self.all_cal_tags_dict.keys()) if
                                         tags not in list(v.keys())]
                    unavailable_tags_cal[k] = required_tags_cal
            return unavailable_tags_cal
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)

    def calculated_df(self):
        try:
            date_output_calculated = {}
            start_date_calculated_tags = list(self.date_output_filtered.keys())[0]
            end_date_calculated_tags = start_date_calculated_tags
            periodic_start_time_calculated_tags = int(start_date_calculated_tags.timestamp()) * 1000
            periodic_end_time_calculated_tags = int((end_date_calculated_tags).timestamp()) * 1000
            query_calculated = Kairos_query().kairos_query(start=periodic_start_time_calculated_tags,
                                                           end=periodic_end_time_calculated_tags,
                                                           tag=self.all_calculated_tags)
            # logger.info(f"Query = {query_calculated}")
            data_calculated = Kairos_query().get_data_from_kairos(query=query_calculated, tags_dict=dict(
                (v, k) for k, v in self.all_cal_tags_dict.items()), date=start_date_calculated_tags)
            # logger.debug(f"Data of all calculated tags for 1st day = {data_calculated}")
            date_output_calculated[start_date_calculated_tags] = data_calculated

            unavailable_tags_cal = self.unavailable_cal_tags(date_output_calculated)
            logger.info(f"unavailable tags calculated = {unavailable_tags_cal}")

            columns_tags_calculated = list(list(date_output_calculated.values())[0].keys())
            value_list_calculated = [list(dic.values()) for dic in list(date_output_calculated.values())]
            value_list_calculated_flat = [item for sublist in value_list_calculated for item in sublist]

            df_calculated = pd.DataFrame(index=[no for no in range(self.df_manual_dcs.shape[0])],
                                         columns=columns_tags_calculated)
            df_calculated.iloc[0, :] = value_list_calculated_flat

            logger.debug(f"Dataframe shape of Calculated tags = {df_calculated.shape}")
            logger.debug(f"{df_calculated}")

            logger.info(f"Calculating calculated column values started")
            df_calculated = CalculationCalculatedColumns().calculations(df_manual_dcs=self.df_manual_dcs,
                                                                        df_calculated=df_calculated)

            logger.info(f"The shape of dataframe = {df_calculated.shape}")
            for col in df_calculated.columns:
                df_calculated[col] = df_calculated[col].astype(float).round(4)
            df_calculated_ebpr = df_calculated.copy()
            return df_calculated_ebpr, df_calculated, unavailable_tags_cal
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)