from loguru import logger


class TagsDict:
    def __init__(self):
        pass

    def Merge(self, dict1, dict2):
        return {**dict1, **dict2}

    def all_tags(self, tags_cal, tags_cal_prev, tags_manual, tags_dcs):
        try:
            manual_dcs_tags = self.Merge(dict1=tags_manual, dict2=tags_dcs)
            cal_calprev_tags = self.Merge(dict1=tags_cal, dict2=tags_cal_prev)
            logger.info(f"No of combined Manual & DCS tags = {len(manual_dcs_tags)} \
                            No of Manual tags only = {len(tags_manual)} \
                            No of DCS tags only = {len(tags_dcs)}")
            logger.info(f"No of combined Cal & Cal prev tags = {len(cal_calprev_tags)} \
                            No of Cal tags only = {len(tags_cal)} \
                            No of Cal prev tags only = {len(tags_cal_prev)}")
            return manual_dcs_tags, cal_calprev_tags
        except Exception as e:
            logger.exception("Exception occurred", exc_info=True)


class AllTags:
    def __init__(self):
        pass

    def get_tags(self, all_tags_dictionary):
        try:
            cal_tags = {tag: {"column_tag": all_tags_dictionary[tag]["column_tag"],
                              "source": all_tags_dictionary[tag]["source"]} for tag, v in all_tags_dictionary.items() if
                        all_tags_dictionary[tag]["source"] == 'calculated'}
            cal_prev_tags = {tag: {"column_tag": all_tags_dictionary[tag]["column_tag"],
                                   "source": all_tags_dictionary[tag]["source"]} for tag, v in
                             all_tags_dictionary.items() if
                             all_tags_dictionary[tag]["source"] == 'calculated_depends_previous_value'}
            manual_tags = {tag: {"column_tag": all_tags_dictionary[tag]["column_tag"],
                                 "source": all_tags_dictionary[tag]["source"]} for tag, v in all_tags_dictionary.items()
                           if all_tags_dictionary[tag]["source"] == 'manual'}
            dcs_tags = {tag: {"column_tag": all_tags_dictionary[tag]["column_tag"],
                              "source": all_tags_dictionary[tag]["source"]} for tag, v in all_tags_dictionary.items() if
                        all_tags_dictionary[tag]["source"] == 'dcs'}
            return self.tags_category(cal_tags, cal_prev_tags, manual_tags, dcs_tags)
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)

    def tags_category(self, cal_tags, cal_prev_tags, manual_tags, dcs_tags):
        try:
            tags_cal = {tag: cal_tags[tag]["column_tag"] for tag, v in cal_tags.items()}
            tags_cal_prev = {tag: cal_prev_tags[tag]["column_tag"] for tag, v in cal_prev_tags.items()}
            tags_manual = {tag: manual_tags[tag]["column_tag"] for tag, v in manual_tags.items()}
            tags_dcs = {tag: dcs_tags[tag]["column_tag"] for tag, v in dcs_tags.items()}
            return tags_cal, tags_cal_prev, tags_manual, tags_dcs
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)

