from loguru import logger


class UnavailableManualDcsTags:
    def __init__(self, date_output, all_manual_dcs_tags, all_manual_dcs_tags_dict, first_date):
        self.date_output=date_output
        self.all_manual_dcs_tags=all_manual_dcs_tags
        self.all_manual_dcs_tags_dict=all_manual_dcs_tags_dict
        self.first_date=first_date

    def unavailable_manual_dcs_tags(self):
        try:
            unavailable_tags = {}
            unavailable_data_date = {k: v for k, v in self.date_output.items() if v is None}
            date_output_without_none = {k: v for k, v in self.date_output.items() if v is not None}
            first_data_date = list(date_output_without_none.keys())[0]
            logger.info(f"No data is avaialble for - {unavailable_data_date}")
            unavailable_data_date.pop(self.first_date, None)
            unavailable_data_date.pop(first_data_date, None)

            if len(unavailable_data_date) > 0:
                return unavailable_tags, unavailable_data_date
            else:
                date_output = self.date_output
                date_output_copy = date_output.copy()
                for k, v in date_output_copy.items():
                    if self.first_date==k:
                        if v is None:
                            date_output.pop(self.first_date, None)
                for k, v in date_output.items():
                    if len(v) != len(self.all_manual_dcs_tags):
                        required_tags = [tags for tags in list(self.all_manual_dcs_tags_dict.keys())
                                         if tags not in list(v.keys())]
                        unavailable_tags[k] = required_tags
                return unavailable_tags, unavailable_data_date
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)