from scripts.utils.yield_sheet_3cp_utils.all_tags_3cp import TagsDict
import pandas as pd
from datetime import datetime, timedelta
from loguru import logger
from scripts.utils.yield_sheet_3cp_utils.data_puller_3cp import Kairos_query


class AllTagsDataPuller:
    def __init__(self, start_date, end_date):
        self.start_date = start_date
        self.end_date = end_date

    def get_kairos_data(self, tags_lst, tags_dict):
        try:
            all_dates = [self.start_date + timedelta(days=x) for x in range((self.end_date - self.start_date).days + 1)]
            logger.debug(f"Data required for dates : {all_dates}")

            date_output = {}
            for dates in all_dates:
                periodic_start_time = dates - timedelta(minutes=0)
                logger.info(f"Pulling data for date - {periodic_start_time}")
                current_date = periodic_start_time
                periodic_start_time = int(periodic_start_time.timestamp()) * 1000
                periodic_end_time = dates + timedelta(minutes=10)
                periodic_end_time = int(periodic_end_time.timestamp()) * 1000
                query_manual_dcs = Kairos_query().kairos_query(start=periodic_start_time, end=periodic_end_time,
                                                               tag=tags_lst)
                logger.info(f"{query_manual_dcs}")
                data_manual_dcs = Kairos_query().get_data_from_kairos(query=query_manual_dcs,
                                                                      tags_dict=dict((v, k) for k, v in
                                                                                     tags_dict.items()),
                                                                      date=current_date)

                date_output[dates] = data_manual_dcs
            return date_output
        except Exception as e:
            logger.exception(f'Exception - {e}')


def get_dataframe(date_dict, tags_lst):
    try:
        df = pd.DataFrame(index=[i for i in range(len(date_dict))], columns=tags_lst)
        df['Date'] = list(date_dict.keys())
        col = df.pop("Date")
        df.insert(0, col.name, col)
        for index in range(df.shape[0]):
            for params in df.columns:
                if params not in ['Date']:
                    present_date = df.iloc[index, df.columns.get_loc('Date')]
                    available_tags = list(date_dict[present_date].keys())
                    if params not in available_tags:
                        df.iloc[index, df.columns.get_loc(params)] = None
                    else:
                        df.iloc[index, df.columns.get_loc(params)] = date_dict[present_date][params]
        df.sort_values('Date', inplace=True)
        df.reset_index(drop=True, inplace=True)
        df = df.astype({'Date': str,
                        '7302011030_Consumptions_Closing_DPR': float, 'D1D001Readings_T_2703_A_DPR': float,
                        'D1D001Readings_T_2703_B_DPR': float, 'D1D001Readings_Conv_DPR': float,
                        'D1D001_consumptions_Day_Receipt_DPR': float, '7302011030_Consumptions_Day_Receipt_DPR': float,
                        '7302011061_Consumption_Day_Receipt_DPR': float, '7302011061_Consumption_Day_Cons_DPR': float,
                        'Pure_Production_Day_Nia_DPR': float, 'Pure_Production_Day_Drum_Filling_DPR': float,
                        'Pure_Production_Pure_tank_Dead_Volumes_DPR': float, 'Utility_report_Day_Power': float,
                        'Utility_report_Day_Steam': float, 'Utility_report_Day_Raffinate': float,
                        'Utility_report_Vent_Gas_Raffinate': float, 'Utility_report_Day_DM': float,
                        'Utility_report_Day_Treated_Water': float, 'Utility_report_Raffinate_Incinerated': float,
                        'Beta_Purification_Column_C_2409_Outlet_Flow_TZ': float, 'D1D001Readings_T_2101_A_DPR': float,
                        'D1D001Readings_T_2101_B_DPR': float, 'Pure_Production_LT_2701_A_DPR': float,
                        'Pure_Production_LT_2701_B_DPR': float, 'D1D001_consumptions_Opening_DPR': float,
                        'D1D001_consumptions_Day_Cons_DPR': float, '7302011030_Consumptions_Opening_DPR': float,
                        '7302011030_Consumptions_Day_Cons_DPR': float, '7302011061_Consumption_Opening_DPR': float,
                        'Crude_Prod_Day_Prod_DPR': float, 'Pure_Production_Opening_DPR': float,
                        'Pure_Production_Day_Prod_DPR': float, 'Utility_report_Power_Norms': float,
                        'Utility_report_Steam_Norms': float, 'Utility_report_Raffinate_Norms': float,
                        'Utility_report_Raffinate_Vent_Gas': float, 'Utility_report_Raw_Water_Norms': float,
                        'Utility_report_per_hr_burn_rate': float, 'D1D001_consumptions_Closing_DPR': float,
                        'Utility_report_Actual_Ammonia_Norms': float, 'Utility_report_Actual_Beta_Norms': float,
                        'Utility_report_Actual_Benzene_Norms': float, 'Utility_report_Day_DM_norm': float,
                        'D1D001_consumptions_Day_Recovery_DPR': float, 'D1D001_consumptions_Total_Receipt_DPR': float,
                        '7302011030_Consumptions_Total_Receipt_DPR': float,
                        '7302011030_Consumptions_Total_Cons_DPR': float,
                        '7302011061_Consumption_Closing_DPR': float, '7302011061_Consumption_Total_Receipt_DPR': float,
                        '7302011061_Consumption_Total_Cons_DPR': float, 'Crude_Prod_Total_Prod_DPR': float,
                        'Pure_Production_Closing_of_Pure_Tanks_only_DPR': float,
                        'Pure_Production_Total_Prod_DPR': float, 'Pure_Production_Total_Nia_DPR': float,
                        'Pure_Production_Total_Drum_Filling_DPR': float})
        return df
    except Exception as e:
        logger.exception(f'Exception - {e}')