import json
import pandas as pd
import requests
from loguru import logger
from scripts.constants.app_configuration import DB


class Kairos_query:
    def __init__(self):
        self.kairos_host = DB.KairosDb.uri
        # "https://iLens:iLensJUB$456@jubilant.ilens.io/kairos"
        self.kairos_url = "{kairos_host}/api/v1/datapoints/query".format(
            kairos_host=self.kairos_host)
        # logger.info(f"kairos URL is {self.kairos_url}")

    def kairos_query(self, start, end, tag):
        try:
            return {
                "metrics": [
                    {
                        "tags": {
                            "c3": tag
                        },
                        "name": "ilens.live_data.raw",
                        "group_by": [
                            {
                                "name": "tag",
                                "tags": ["c3"]
                            }
                        ],
                        "aggregators": [
                            {
                                "name": "last",
                                "sampling": {
                                    "value": "2",
                                    "unit": "minutes"
                                }
                            }
                        ]
                    }
                ],
                "plugins": [],
                "cache_time": 0,
                "time_zone": "Asia/Calcutta",
                "start_absolute": start,
                "end_absolute": end,
            }
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)

    def get_data_from_kairos(self, query, tags_dict, date):
        output = {}
        try:
            response = requests.post(self.kairos_url, data=json.dumps(query))
            grouped_output_data = response.json()["queries"][0]["results"]
            for each_grouped_data in grouped_output_data:
                value = (each_grouped_data["values"])
                tem = each_grouped_data.get('group_by', None)
                tag_id = None
                if tem is not None:
                    tag_id = each_grouped_data["group_by"][0]["group"]["c3"]
                else:
                    for k, v in tags_dict.items():
                        output[v] = 0
                try:
                    output[tags_dict[tag_id]] = round(value[0][1], 2)
                except Exception as e:
                    logger.exception(f"Exception - {e}", exc_info=True)
                    output[tags_dict[tag_id]] = 0
            return output
        except Exception as e:
            logger.exception(f"Exception occurred - {e} for date = {date}", exc_info=True)
