import pandas as pd
from loguru import logger

class ConcatenateManualCalculatedDf:
    def __init__(self, df_manual_dcs_ebpr, df_calculated_ebpr, start_date):
        self.df_manual_dcs_ebpr=df_manual_dcs_ebpr
        self.df_calculated_ebpr=df_calculated_ebpr
        self.start_date=start_date
    def concate_manual_calculated_df(self):
        try:
            self.df_manual_dcs_ebpr.drop(['Beta_Purification_Column_C_2409_Outlet_Flow_TZ'], axis=1, inplace=True)
            df_ebpr = pd.concat([self.df_manual_dcs_ebpr, self.df_calculated_ebpr], axis=1)
            if df_ebpr['Date'][0] == self.start_date:
                df_ebpr = df_ebpr[df_ebpr['Date'] > self.start_date]
            # df_ebpr['Date'] = df_ebpr['Date'] + timedelta(days=1)
            df_ebpr['Date'] = df_ebpr['Date'].dt.strftime('%Y-%m-%d')
            return df_ebpr
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)