if __name__ == "__main__":
    from dotenv import load_dotenv
    load_dotenv(dotenv_path='config.env')
import pandas as pd
import xlsxwriter
import os
import yaml
from datetime import datetime
import pytz
from loguru import logger
from scripts.utils.yield_sheet_3cp_utils.all_tags_3cp import AllTags
from scripts.utils.yield_sheet_3cp_utils.report_generator_3cp import ReportGenerator, get_dpr_report_format, \
    get_dpr


def form_excel_multiindex(df, df_format):
    # ebpr_dir = os.path.join(FilePath.report_directory, "ebpr")
    # if not os.path.exists(ebpr_dir):
    #     os.mkdir(ebpr_dir)
    #
    # output_dir = os.path.join(ebpr_dir, "yield")
    # if not os.path.exists(output_dir):
    #     os.mkdir(output_dir)

    master_output_file = 'test_prod.xlsx'
    master_output_file = get_dpr(master_output_file=master_output_file, df=df, df_format=df_format)
    logger.info("XLSX is getting stitched")
    # logger.info(f"{os.listdir(output_dir)}")
    if os.path.isfile(master_output_file):
        return master_output_file, ""
    else:
        return None, "File not created"







# __kwargs__.update(
#     start_date=input_data.property.get(
#         "start_date",
#         datetime.now(tz=pytz.timezone(input_data.tz)).strftime("%Y-%m-%d"),
#
#     ),
#     end_date=input_data.property.get(
#         "end_date",
#         datetime.now(tz=pytz.timezone(input_data.tz)).strftime("%Y-%m-%d"))
# )
# try:
#     logger.info("Calculating Report for 3CP")
#     start_date = str(__kwargs__.get('start_date'))
#     end_date = str(__kwargs__.get('end_date'))

yml_file_path = "scripts/utils/yield_sheet_3cp_utils/"
try:
    with open(os.path.join(yml_file_path, 'engine.yml'), 'r') as engine_yml_file:
        config_engine = yaml.full_load(engine_yml_file)

except Exception as e:
    logger.exception(f"Exception occurred - {e}", exc_info=True)
all_tags = config_engine["tag_heirarcy"]

tags_cal, tags_cal_prev, tags_manual, tags_dcs = AllTags().get_tags(all_tags_dictionary=all_tags)
# start_date = datetime.strptime(start_date, '%Y-%m-%d')
# start_date = start_date.astimezone(pytz.UTC)
start_date = datetime.strptime("2023-02-05", '%Y-%m-%d').replace(hour=5, minute=0, second=0,
                                                                 microsecond=0)
start_date = start_date.astimezone(pytz.timezone("Asia/Kolkata")).replace(hour=5, minute=0, second=0,
                                                                          microsecond=0)

end_date = datetime.strptime("2023-03-20", '%Y-%m-%d').replace(hour=5, minute=0, second=0,
                                                               microsecond=0)
end_date = end_date.astimezone(pytz.timezone("Asia/Kolkata")).replace(hour=5, minute=0, second=0,
                                                                      microsecond=0)

df_format, df, message = ReportGenerator(tags_cal=tags_cal, tags_cal_prev=tags_cal_prev, tags_manual=tags_manual,
                                         tags_dcs=tags_dcs, start_date=start_date,
                                         end_date=end_date).yield_report_3cp()


logger.debug(f'{df.shape}')
logger.debug(f'{message}')

form_excel_multiindex(df=df, df_format=df_format)

