import numpy as np
import warnings
warnings.filterwarnings("ignore")
import traceback
from loguru import logger
import pandas as pd
from datetime import datetime, timedelta
from scripts.utils.yield_sheet_3cp_utils.all_tags_3cp import TagsDict
enable_traceback = True
from scripts.utils.yield_sheet_3cp_utils.manual_dcs_dataframe import ManualDcsData
from scripts.utils.yield_sheet_3cp_utils.unavailable_manual_dcs_tags import UnavailableManualDcsTags
from scripts.utils.yield_sheet_3cp_utils.ebpr_manual_dataframe import EbprManualDcsDataframe
from scripts.utils.yield_sheet_3cp_utils.calculated_dataframe import CalculatedDataframe
from scripts.utils.yield_sheet_3cp_utils.concat_manual_calculated_dataframe import ConcatenateManualCalculatedDf
from scripts.utils.yield_sheet_3cp_utils.reorder_renaming_ebpr import ReorderRename

class ReportGenerator:
    def __init__(self, tags_cal, tags_cal_prev, tags_manual, tags_dcs, start_date, end_date):
        self.tags_cal = tags_cal
        self.tags_cal_prev = tags_cal_prev
        self.tags_manual = tags_manual
        self.tags_dcs = tags_dcs
        self.start_date = start_date - timedelta(days=1)
        self.end_date = end_date

    def yield_report_3cp(self):
        try:
            date_output = ManualDcsData(start_date=self.start_date, end_date=self.end_date, tags_cal=self.tags_cal,
                                        tags_cal_prev=self.tags_cal_prev, tags_manual=self.tags_manual,
                                        tags_dcs=self.tags_dcs).manual_dcs_dataframe()

            all_manual_dcs_tags_dict, all_cal_tags_dict = TagsDict().all_tags(self.tags_cal, self.tags_cal_prev,
                                                                              self.tags_manual, self.tags_dcs)
            all_manual_dcs_tags = list(all_manual_dcs_tags_dict.values())

            all_calculated_tags = list(all_cal_tags_dict.values())

            all_tags = [*all_calculated_tags, *all_manual_dcs_tags]
            all_tags_dict = {**all_cal_tags_dict, **all_manual_dcs_tags_dict}

            unavailable_tags, unavailable_data_date = UnavailableManualDcsTags(date_output=date_output,
                                                        all_manual_dcs_tags=all_manual_dcs_tags,
                                                        all_manual_dcs_tags_dict=all_manual_dcs_tags_dict,
                                                        first_date=self.start_date).unavailable_manual_dcs_tags()
            if len(unavailable_data_date)>0:
                logger.info(f"No data is available for - {unavailable_data_date}")
                return None, f"No data is available for - {unavailable_data_date}"
            else:
                logger.info(f"Given tags are missing for dates - {unavailable_tags}")
                unavailable_tags.pop(self.start_date, None)
                if len(unavailable_tags)>=1:
                    logger.info(f"Given tags are missing for Date - {unavailable_tags}")
                    return None, f"Given tags are missing for Date - {unavailable_tags}"
                else:
                    df_manual_dcs, df_manual_dcs_ebpr, date_output_filtered = EbprManualDcsDataframe(date_output=date_output,
                                                                                    all_manual_dcs_tags=all_manual_dcs_tags).\
                                                                                    ebpr_manual_dcs_dataframe()

                    df_calculated_ebpr, df_calculated, unavailable_tags_cal = CalculatedDataframe(date_output_filtered=
                                                                                                  date_output_filtered,
                                                                                all_calculated_tags=all_calculated_tags,
                                                                                all_cal_tags_dict=all_cal_tags_dict,
                                                                                df_manual_dcs=df_manual_dcs).calculated_df()

                    df_ebpr = ConcatenateManualCalculatedDf(df_manual_dcs_ebpr=df_manual_dcs_ebpr,
                                                            df_calculated_ebpr=df_calculated_ebpr,
                                                            start_date=self.start_date).concate_manual_calculated_df()
                    df_ebpr_copy = df_ebpr.copy()
                    df_ebpr.replace([np.inf, -np.inf], np.nan, inplace=True)
                    # a = df_ebpr['Utility_report_Power_Norms'].unique()
                    # col_name = df_ebpr.columns[1:]
                    # for col in col_name:
                    #     df_ebpr[col] = df_ebpr[col].replace([inf], 'nan')

                    total_list = []
                    for col in [col for col in list(df_ebpr.columns) if col not in ('Date',
                                                                                    'Utility_report_Power_Norms',
                                                                                    'Utility_report_Steam_Norms',
                                                                                    'Utility_report_Raffinate_Norms',
                                                                                    'Utility_report_Raffinate_Vent_Gas',
                                                                                    'Utility_report_Raw_Water_Norms',
                                                                                    'Utility_report_Actual_Ammonia_Norms',
                                                                                    'Utility_report_Actual_Beta_Norms',
                                                                                    'Utility_report_Day_DM_norm',
                                                                                    'Utility_report_Actual_Benzene_Norms')]:
                        # total_list.append(df_ebpr[col].sum())
                        df_ebpr.loc['Total', col] = df_ebpr[col].sum()
                    # df_ebpr.loc['Total'] = [i for i in range(df_ebpr.shape[1])]
                    # df_ebpr.iloc[-1, 1:] = total_list
                    df_ebpr['Date'][-1] = 'Total'
                    average_list = []
                    for col in [col for col in list(df_ebpr.columns) if col in ('Utility_report_Power_Norms',
                                                                                'Utility_report_Steam_Norms',
                                                                                'Utility_report_Raffinate_Norms',
                                                                                'Utility_report_Raffinate_Vent_Gas',
                                                                                'Utility_report_Raw_Water_Norms',
                                                                                'Utility_report_Actual_Ammonia_Norms',
                                                                                'Utility_report_Actual_Beta_Norms',
                                                                                'Utility_report_Day_DM_norm',
                                                                                'Utility_report_Actual_Benzene_Norms')]:
                        df_ebpr.loc['Average', col] = df_ebpr[col].mean()
                        # average_list.append(df_ebpr[col].mean())
                    # df_ebpr.loc['Average'] = [i for i in range(df_ebpr.shape[1])]
                    # df_ebpr.iloc[-1, 1:] = average_list
                    df_ebpr['Date'][-1] = 'Average'
                    df_ebpr = df_ebpr.round(3)

                    df_concat = ReorderRename(df_ebpr=df_ebpr).reorder_rename()
                    df_concat.replace({'inf': 'nan'}, inplace=True)
                    return df_concat, f"Report is ready"
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)
            return None, f"Error - {e}"
