import pandas as pd
from loguru import logger


class ReorderRename:
    def __init__(self,df_ebpr):
        self.df_ebpr=df_ebpr
    def reorder_rename(self):
        try:
            df1 = self.df_ebpr[['Date',

                           'D1D001Readings_T_2703_A_DPR', 'D1D001Readings_T_2703_B_DPR',
                           'D1D001Readings_T_2101_A_DPR', 'D1D001Readings_T_2101_B_DPR', 'D1D001Readings_Conv_DPR',

                           'D1D001_consumptions_Opening_DPR', 'D1D001_consumptions_Day_Receipt_DPR',
                           'D1D001_consumptions_Day_Recovery_DPR',
                           'D1D001_consumptions_Total_Receipt_DPR', 'D1D001_consumptions_Day_Cons_DPR',
                           'D1D001_consumptions_Closing_DPR',

                           '7302011030_Consumptions_Opening_DPR', '7302011030_Consumptions_Day_Receipt_DPR',
                           '7302011030_Consumptions_Total_Receipt_DPR', '7302011030_Consumptions_Day_Cons_DPR',
                           '7302011030_Consumptions_Total_Cons_DPR', '7302011030_Consumptions_Closing_DPR',

                           '7302011061_Consumption_Opening_DPR', '7302011061_Consumption_Day_Receipt_DPR',
                           '7302011061_Consumption_Total_Receipt_DPR', '7302011061_Consumption_Day_Cons_DPR',
                           '7302011061_Consumption_Total_Cons_DPR', '7302011061_Consumption_Closing_DPR',

                           'Crude_Prod_Day_Prod_DPR', 'Crude_Prod_Total_Prod_DPR',

                           'Pure_Production_Opening_DPR', 'Pure_Production_Day_Prod_DPR',
                           'Pure_Production_Total_Prod_DPR',
                           'Pure_Production_Day_Nia_DPR', 'Pure_Production_Total_Nia_DPR',
                           'Pure_Production_Day_Drum_Filling_DPR',
                           'Pure_Production_Total_Drum_Filling_DPR',
                           'Pure_Production_LT_2701_A_DPR', 'Pure_Production_LT_2701_B_DPR',
                           'Pure_Production_Closing_of_Pure_Tanks_only_DPR',
                           'Pure_Production_Pure_tank_Dead_Volumes_DPR',

                           'Utility_report_Day_Power', 'Utility_report_Day_Steam',
                           'Utility_report_Day_Raffinate', 'Utility_report_Vent_Gas_Raffinate',
                           'Utility_report_Day_DM',
                            'Utility_report_Day_DM_norm',
                            'Utility_report_Day_Treated_Water',
                           'Utility_report_Raffinate_Incinerated',
                            # 'Utility_report_Compressor',
                           'Utility_report_Actual_Ammonia_Norms',
                           'Utility_report_Actual_Beta_Norms',
                           'Utility_report_Actual_Benzene_Norms',
                           # 'Utility_report_Actual_Air_Norms',
                           'Utility_report_Power_Norms',
                           'Utility_report_Steam_Norms', 'Utility_report_Raffinate_Norms',
                           'Utility_report_Raffinate_Vent_Gas', 'Utility_report_Raw_Water_Norms',
                           # 'Utility_report_Actual_Day_Prod',
                            'Utility_report_per_hr_burn_rate',
                           # 'Utility_report_Day_Air'
                           ]]

            df1_trans = df1.transpose()
            df1_trans['Parameter'] = list(df1_trans.index)
            df1_trans.index = [i for i in range(df1_trans.shape[0])]
            df1_trans.columns = [df1_trans.iloc[0, :]]
            df1_trans = df1_trans.iloc[1:, :]
            # shift column 'Date' to first position
            first_column = df1_trans.pop(('Date',))
            # insert column using insert(position,column_name,first_column) function
            df1_trans.insert(0, ('Date',), first_column)

            df1_trans['Parameter'] = ["BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "BETAPICOLENE",
                                      "AMMONIA",
                                      "AMMONIA",
                                      "AMMONIA",
                                      "AMMONIA",
                                      "AMMONIA",
                                      "AMMONIA",
                                      "BENZENE",
                                      "BENZENE",
                                      "BENZENE",
                                      "BENZENE",
                                      "BENZENE",
                                      "BENZENE",
                                      "CRUDE",
                                      "CRUDE",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "PURE PROD",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      "UTILITY",
                                      # "UTILITY",
                                      # "UTILITY",
                                      # "UTILITY"
                                      ]

            # shift column 'Name' to first position
            first_column = df1_trans.pop(('Parameter',))

            # insert column using insert(position,column_name,
            # first_column) function
            df1_trans.insert(0, ('Parameter',), first_column)

            df1_trans.columns = [col[0] for col in df1_trans.columns]
            gg = df1_trans.groupby(['Parameter', 'Date'])
            gg1 = gg.first().transpose()
            gg2 = gg1[[('BETAPICOLENE', 'D1D001Readings_Conv_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2101_A_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2101_B_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2703_A_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2703_B_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Closing_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Cons_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Receipt_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Recovery_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Opening_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Total_Receipt_DPR'),

                       ('AMMONIA', '7302011030_Consumptions_Closing_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Day_Cons_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Day_Receipt_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Opening_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Total_Cons_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Total_Receipt_DPR'),

                       ('BENZENE', '7302011061_Consumption_Closing_DPR'),
                       ('BENZENE', '7302011061_Consumption_Day_Cons_DPR'),
                       ('BENZENE', '7302011061_Consumption_Day_Receipt_DPR'),
                       ('BENZENE', '7302011061_Consumption_Opening_DPR'),
                       ('BENZENE', '7302011061_Consumption_Total_Cons_DPR'),
                       ('BENZENE', '7302011061_Consumption_Total_Receipt_DPR'),

                       ('CRUDE', 'Crude_Prod_Day_Prod_DPR'),
                       ('CRUDE', 'Crude_Prod_Total_Prod_DPR'),
                       ('PURE PROD', 'Pure_Production_Closing_of_Pure_Tanks_only_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Drum_Filling_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Nia_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Prod_DPR'),
                       ('PURE PROD', 'Pure_Production_LT_2701_A_DPR'),
                       ('PURE PROD', 'Pure_Production_LT_2701_B_DPR'),
                       ('PURE PROD', 'Pure_Production_Opening_DPR'),
                       ('PURE PROD', 'Pure_Production_Pure_tank_Dead_Volumes_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Drum_Filling_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Nia_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Prod_DPR'),
                       # ('UTILITY', 'Utility_report_Actual_Air_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Ammonia_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Benzene_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Beta_Norms'),
                       # ('UTILITY', 'Utility_report_Actual_Day_Prod'),
                       # ('UTILITY', 'Utility_report_Compressor'),
                       # ('UTILITY', 'Utility_report_Day_Air'),
                       ('UTILITY', 'Utility_report_Day_DM'),
                       ('UTILITY', 'Utility_report_Day_DM_norm'),
                       ('UTILITY', 'Utility_report_Day_Power'),
                       ('UTILITY', 'Utility_report_Day_Raffinate'),
                       ('UTILITY', 'Utility_report_Day_Steam'),
                       ('UTILITY', 'Utility_report_Day_Treated_Water'),
                       ('UTILITY', 'Utility_report_Power_Norms'),
                       ('UTILITY', 'Utility_report_Raffinate_Incinerated'),
                       ('UTILITY', 'Utility_report_Raffinate_Norms'),
                       ('UTILITY', 'Utility_report_Raffinate_Vent_Gas'),
                       ('UTILITY', 'Utility_report_Raw_Water_Norms'),
                       ('UTILITY', 'Utility_report_Steam_Norms'),
                       ('UTILITY', 'Utility_report_Vent_Gas_Raffinate'),
                       ('UTILITY', 'Utility_report_per_hr_burn_rate')]]

            gg2 = gg2[[('BETAPICOLENE', 'D1D001Readings_T_2703_A_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2703_B_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2101_A_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_T_2101_B_DPR'),
                       ('BETAPICOLENE', 'D1D001Readings_Conv_DPR'),

                       ('BETAPICOLENE', 'D1D001_consumptions_Opening_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Receipt_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Recovery_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Total_Receipt_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Day_Cons_DPR'),
                       ('BETAPICOLENE', 'D1D001_consumptions_Closing_DPR'),

                       ('AMMONIA', '7302011030_Consumptions_Opening_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Day_Receipt_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Total_Receipt_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Day_Cons_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Total_Cons_DPR'),
                       ('AMMONIA', '7302011030_Consumptions_Closing_DPR'),

                       ('BENZENE', '7302011061_Consumption_Opening_DPR'),
                       ('BENZENE', '7302011061_Consumption_Day_Receipt_DPR'),
                       ('BENZENE', '7302011061_Consumption_Total_Receipt_DPR'),
                       ('BENZENE', '7302011061_Consumption_Day_Cons_DPR'),
                       ('BENZENE', '7302011061_Consumption_Total_Cons_DPR'),
                       ('BENZENE', '7302011061_Consumption_Closing_DPR'),

                       ('CRUDE', 'Crude_Prod_Day_Prod_DPR'),
                       ('CRUDE', 'Crude_Prod_Total_Prod_DPR'),

                       ('PURE PROD', 'Pure_Production_Opening_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Prod_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Prod_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Nia_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Nia_DPR'),
                       ('PURE PROD', 'Pure_Production_Day_Drum_Filling_DPR'),
                       ('PURE PROD', 'Pure_Production_Total_Drum_Filling_DPR'),
                       ('PURE PROD', 'Pure_Production_LT_2701_A_DPR'),
                       ('PURE PROD', 'Pure_Production_LT_2701_B_DPR'),
                       ('PURE PROD', 'Pure_Production_Closing_of_Pure_Tanks_only_DPR'),
                       ('PURE PROD', 'Pure_Production_Pure_tank_Dead_Volumes_DPR'),

                       ('UTILITY', 'Utility_report_Power_Norms'),
                       ('UTILITY', 'Utility_report_Steam_Norms'),
                       ('UTILITY', 'Utility_report_Raffinate_Norms'),
                       ('UTILITY', 'Utility_report_Raffinate_Vent_Gas'),
                       ('UTILITY', 'Utility_report_Raw_Water_Norms'),
                       ('UTILITY', 'Utility_report_Day_Power'),
                       ('UTILITY', 'Utility_report_Day_Steam'),
                       ('UTILITY', 'Utility_report_Day_Raffinate'),
                       ('UTILITY', 'Utility_report_Vent_Gas_Raffinate'),
                       ('UTILITY', 'Utility_report_Day_DM'),
                       ('UTILITY', 'Utility_report_Day_DM_norm'),
                       ('UTILITY', 'Utility_report_Day_Treated_Water'),
                       ('UTILITY', 'Utility_report_Raffinate_Incinerated'),
                       ('UTILITY', 'Utility_report_per_hr_burn_rate'),
                       # ('UTILITY', 'Utility_report_Actual_Air_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Ammonia_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Benzene_Norms'),
                       ('UTILITY', 'Utility_report_Actual_Beta_Norms'),
                       # ('UTILITY', 'Utility_report_Actual_Day_Prod'),
                       # ('UTILITY', 'Utility_report_Compressor'),
                       # ('UTILITY', 'Utility_report_Day_Air'),
                       ]]

            mapping_dict = {('BETAPICOLENE', 'D1D001Readings_T_2703_A_DPR'): ('D1D001', 'T-2703 A (%)'),
                            ('BETAPICOLENE', 'D1D001Readings_T_2703_B_DPR'): ('D1D001', 'T-2703 B (%)'),
                            ('BETAPICOLENE', 'D1D001Readings_T_2101_A_DPR'): ('D1D001', 'T-2101 A (%)'),
                            ('BETAPICOLENE', 'D1D001Readings_T_2101_B_DPR'): ('D1D001', 'T-2101 B (%)'),
                            ('BETAPICOLENE', 'D1D001Readings_Conv_DPR'): ('D1D001', 'Conversion (%)'),

                            ('BETAPICOLENE', 'D1D001_consumptions_Opening_DPR'): ('D1D001', 'Opening Stock (MT)'),
                            ('BETAPICOLENE', 'D1D001_consumptions_Day_Receipt_DPR'): ('D1D001', 'Day Receipt (MT)'),
                            ('BETAPICOLENE', 'D1D001_consumptions_Day_Recovery_DPR'): ('D1D001', 'Day Recovery (MT)'),
                            ('BETAPICOLENE', 'D1D001_consumptions_Total_Receipt_DPR'): ('D1D001', 'Total Receipt (MT)'),
                            ('BETAPICOLENE', 'D1D001_consumptions_Day_Cons_DPR'): ('D1D001', 'Day Consumption (MT)'),
                            ('BETAPICOLENE', 'D1D001_consumptions_Closing_DPR'): ('D1D001', 'Closing Stock (MT)'),

                            ('AMMONIA', '7302011030_Consumptions_Opening_DPR'): (
                            '7302011030 Consumption', 'Opening Stock (MT)'),
                            ('AMMONIA', '7302011030_Consumptions_Day_Receipt_DPR'): (
                            '7302011030 Consumption', 'Day Receipt (MT)'),
                            ('AMMONIA', '7302011030_Consumptions_Total_Receipt_DPR'): (
                            '7302011030 Consumption', 'Total Receipt (MT)'),
                            ('AMMONIA', '7302011030_Consumptions_Day_Cons_DPR'): (
                            '7302011030 Consumption', 'Day Consumption (MT)'),
                            ('AMMONIA', '7302011030_Consumptions_Total_Cons_DPR'): (
                            '7302011030 Consumption', 'Total Consumption (MT)'),
                            ('AMMONIA', '7302011030_Consumptions_Closing_DPR'): (
                            '7302011030 Consumption', 'Closing Stock (MT)'),

                            ('BENZENE', '7302011061_Consumption_Opening_DPR'): (
                            '7302011061 Consumption', 'Opening Stock (MT)'),
                            ('BENZENE', '7302011061_Consumption_Day_Receipt_DPR'): (
                            '7302011061 Consumption', 'Day Receipt (MT)'),
                            ('BENZENE', '7302011061_Consumption_Total_Receipt_DPR'): (
                            '7302011061 Consumption', 'Total Receipt (MT)'),
                            ('BENZENE', '7302011061_Consumption_Day_Cons_DPR'): (
                            '7302011061 Consumption', 'Day Consumption (MT)'),
                            ('BENZENE', '7302011061_Consumption_Total_Cons_DPR'): (
                            '7302011061 Consumption', 'Total Consumption (MT)'),
                            ('BENZENE', '7302011061_Consumption_Closing_DPR'): (
                            '7302011061 Consumption', 'Closing Stock (MT)'),

                            ('CRUDE', 'Crude_Prod_Day_Prod_DPR'): ('Crude 3-CP Production', 'Day Production (MT)'),
                            ('CRUDE', 'Crude_Prod_Total_Prod_DPR'): ('Crude 3-CP Production', 'Total Production (MT)'),

                            ('PURE PROD', 'Pure_Production_Opening_DPR'): ('Pure 3-CP  Production', 'Opening Stock (MT)'),
                            ('PURE PROD', 'Pure_Production_Day_Prod_DPR'): ('Pure 3-CP  Production', 'Day Production (MT)'),
                            ('PURE PROD', 'Pure_Production_Total_Prod_DPR'): (
                            'Pure 3-CP  Production', 'Total Production (MT)'),
                            ('PURE PROD', 'Pure_Production_Day_Nia_DPR'): (
                            'Pure 3-CP  Production', 'Day NIA. Transfer (MT)'),
                            ('PURE PROD', 'Pure_Production_Total_Nia_DPR'): (
                            'Pure 3-CP  Production', 'Total NIA. Transfer (MT)'),
                            ('PURE PROD', 'Pure_Production_Day_Drum_Filling_DPR'): (
                            'Pure 3-CP  Production', 'Day Drum Filling (MT)'),
                            ('PURE PROD', 'Pure_Production_Total_Drum_Filling_DPR'): (
                            'Pure 3-CP  Production', 'Total Drum Filling (MT)'),
                            ('PURE PROD', 'Pure_Production_LT_2701_A_DPR'): ('Pure 3-CP  Production', 'LT-2701 A (%)'),
                            ('PURE PROD', 'Pure_Production_LT_2701_B_DPR'): ('Pure 3-CP  Production', 'LT T-2701 B(%)'),
                            ('PURE PROD', 'Pure_Production_Closing_of_Pure_Tanks_only_DPR'): (
                            'Pure 3-CP  Production', 'Closing Stock of Pure Tanks (MT)'),
                            ('PURE PROD', 'Pure_Production_Pure_tank_Dead_Volumes_DPR'): (
                            'Pure 3-CP  Production', 'Pure tank Dead Volume (MT)'),

                            ('UTILITY', 'Utility_report_Day_Power'): ('UTILITY', 'Day Power Consumption (KWH)'),
                            ('UTILITY', 'Utility_report_Power_Norms'): ('UTILITY', 'Power Norm (KWH/MT)'),
                            ('UTILITY', 'Utility_report_Day_Steam'): ('UTILITY', 'Day Steam Consumption (MT)'),
                            ('UTILITY', 'Utility_report_Steam_Norms'): ('UTILITY', 'Steam Norm (MT/MT)'),
                            ('UTILITY', 'Utility_report_Day_Raffinate'): ('UTILITY', 'Day Raffinate Generation (M3)'),
                            ('UTILITY', 'Utility_report_Raffinate_Norms'): ('UTILITY', 'Raffinate Norm (M3/MT)'),
                            ('UTILITY', 'Utility_report_Vent_Gas_Raffinate'): (
                            'UTILITY', 'Day Vent Gas Raffinate Generation (M3)'),
                            ('UTILITY', 'Utility_report_Raffinate_Vent_Gas'): ('UTILITY', 'Raffinate Vent Gas Norm (M3/MT)'),
                            ('UTILITY', 'Utility_report_Day_Treated_Water'): (
                                'UTILITY', 'Day Treated Water Consumption (M3)'),
                            ('UTILITY', 'Utility_report_Raw_Water_Norms'): ('UTILITY', 'Treated  Water Norm (M3/MT)'),
                            ('UTILITY', 'Utility_report_Day_DM'): ('UTILITY', 'Day D.M.W. Consumption (M3)'),
                            ('UTILITY', 'Utility_report_Day_DM_norm'): ('UTILITY', 'D.M.W. Norm (M3/MT)'),

                            ('UTILITY', 'Utility_report_Raffinate_Incinerated'): (
                            'UTILITY', 'Day Raffinate Incinerated (M3)'),
                            ('UTILITY', 'Utility_report_per_hr_burn_rate'): (
                            'UTILITY', 'Raffinate Incineration Rate (Kg/Hr)'),
                            # ('UTILITY', 'Utility_report_Actual_Air_Norms'): ('UTILITY', 'Actual_Air_Norm'),
                            ('UTILITY', 'Utility_report_Actual_Ammonia_Norms'): ('UTILITY', 'Ammonia Norm (MT/MT)'),
                            ('UTILITY', 'Utility_report_Actual_Benzene_Norms'): ('UTILITY', 'Benzene Norm (MT/MT)'),
                            ('UTILITY', 'Utility_report_Actual_Beta_Norms'): ('UTILITY', 'Beta Picoline  Norm (MT/MT)'),
                            # ('UTILITY', 'Utility_report_Actual_Day_Prod'): ('UTILITY', 'Actual Day Prod. (MT)'),
                            # ('UTILITY', 'Utility_report_Compressor'): ('UTILITY', 'Compressor'),
                            # ('UTILITY', 'Utility_report_Day_Air'): ('UTILITY', 'Day Air')
                            }

            # Dictionary allows using tuples as keys and values
            def rename_tuple(tuple_, dict_):
                """Replaces tuple if present in tuple dict"""
                if tuple_ in dict_.keys():
                    return dict_[tuple_]
                return tuple_

            # Rename chosen elements from list of tuples from df.columns
            altered_index_list = [rename_tuple(tuple_, mapping_dict) for tuple_ in gg2.columns.to_list()]

            # Update columns with new renamed columns
            gg2.columns = pd.Index(altered_index_list)

            gg_BETAPICOLENE = gg2.iloc[:, :11]
            gg_BETAPICOLENE.insert(gg_BETAPICOLENE.shape[1], " ", " ")
            gg_AMMONIA = gg2.iloc[:, 11:17]
            gg_AMMONIA.insert(gg_AMMONIA.shape[1], " ", " ")
            gg_BEN = gg2.iloc[:, 17:23]
            gg_BEN.insert(gg_BEN.shape[1], " ", " ")
            gg_CRUDE = gg2.iloc[:, 23:25]
            gg_CRUDE.insert(gg_CRUDE.shape[1], " ", " ")
            gg_PURE = gg2.iloc[:, 25:36]
            gg_PURE.insert(gg_PURE.shape[1], " ", " ")
            gg_UTILITY = gg2.iloc[:, 36:53]
            gg_UTILITY.insert(gg_UTILITY.shape[1], " ", " ")
            df_concat = pd.concat([gg_BETAPICOLENE, gg_AMMONIA, gg_BEN, gg_CRUDE, gg_PURE, gg_UTILITY], axis=1,
                                  ignore_index=False)

            df_concat.columns = df_concat.columns.rename("Date", level=1)
            return df_concat
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)