from scripts.utils.yield_sheet_3cp_utils.all_tags_3cp import TagsDict
import pandas as pd
from datetime import datetime, timedelta
from loguru import logger
from scripts.utils.yield_sheet_3cp_utils.data_puller_3cp import Kairos_query


class ManualDcsData:
    def __init__(self, start_date, end_date, tags_cal, tags_cal_prev, tags_manual, tags_dcs):
        self.start_date = start_date
        self.end_date = end_date
        self.tags_cal = tags_cal
        self.tags_cal_prev = tags_cal_prev
        self.tags_manual = tags_manual
        self.tags_dcs = tags_dcs

    def manual_dcs_dataframe(self):
        try:
            all_manual_dcs_tags_dict, all_cal_tags_dict = TagsDict().all_tags(self.tags_cal, self.tags_cal_prev,
                                                                              self.tags_manual, self.tags_dcs)
            all_manual_dcs_tags = list(all_manual_dcs_tags_dict.values())
            # logger.info(f"No of manual and dcs tags = {len(all_manual_dcs_tags)}")

            # All calculated tags combined
            all_calculated_tags = list(all_cal_tags_dict.values())
            # logger.info(f"No of all calculated tags = {len(all_calculated_tags)}")

            all_tags = [*all_calculated_tags, *all_manual_dcs_tags]
            all_tags_dict = {**all_cal_tags_dict, **all_manual_dcs_tags_dict}

            # All dates for which we are going to do calculations
            all_dates = [self.start_date + timedelta(days=x) for x in range((self.end_date - self.start_date).days + 1)]
            # all_dates.insert(0, self.start_date)
            logger.debug(f"Data required for dates : {all_dates}")

            # Pulling data for all manual and dcs dates for required dates
            date_output = {}
            for dates in all_dates:
                try:
                    periodic_start_time = dates
                    logger.info(f"Pulling Manual and DCS data for date - {periodic_start_time}")
                    current_date = periodic_start_time
                    periodic_start_time = int(periodic_start_time.timestamp()) * 1000
                    periodic_end_time = int(dates.timestamp()) * 1000
                    query_manual_dcs = Kairos_query().kairos_query(start=periodic_start_time, end=periodic_end_time,
                                                                   tag=all_manual_dcs_tags)
                    logger.info(f"{query_manual_dcs}")
                    data_manual_dcs = Kairos_query().get_data_from_kairos(query=query_manual_dcs,
                                                                          tags_dict=dict((v, k)
                                                                          for k, v in all_manual_dcs_tags_dict.items()),
                                                                          date=current_date)
                    date_output[current_date] = data_manual_dcs
                except Exception as e:
                    logger.exception(f"Exception occurred", exc_info=True)
            return date_output
        except Exception as e:
            logger.exception(f"Exception occurred - {e}", exc_info=True)