if __name__ == "__main__":
    from dotenv import load_dotenv

    load_dotenv(dotenv_path='config.env')
import datetime
import os
import os.path
import sys
from configparser import ConfigParser, BasicInterpolation
import yaml
from loguru import logger

# Configuring file constants
data_conf = "./conf/data.yml"
engine_conf = "./conf/engine.yml"


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(f"conf/application.conf")
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class DB:
    class KairosDb:
        uri = config["KAIROS_DB"]["uri"]






