import pandas as pd
import requests
from pymongo import MongoClient

MONGO_URI = "MONGO_URI"
ilens_configuration = "ilens_configuration"
ilens_asset_model_details = "ilens_asset_model"
project_id = 'PROJECT_ID'
project_prefix = True
public_uri = "PUBLIC_URI"
login_token = 'LOGIN-TOKEN'
ilens_configuration = f'{project_id}__{ilens_configuration}' if project_prefix else ilens_configuration
ilens_asset_model_details = f'{project_id}__{ilens_asset_model_details}' if project_prefix else ilens_asset_model_details
excel_file = 'cdc tags.xlsx'
sheet_name = 'Tags Info'
df = pd.read_excel(excel_file, sheet_name=sheet_name)
split_data = df['Tag ID'].str.split('$', expand=True)
last_positions = split_data.iloc[:, -1]
df['tag_ids'] = last_positions
tag_ids = df['tag_ids'].unique()
print(f'{tag_ids} - {len(tag_ids)}')
connection = MongoClient(MONGO_URI)
ilens_db = connection[ilens_configuration]
tags = ilens_db["tags"]
tag_hierarchy = ilens_db["tag_hierarchy"]
print("Deleting Parameters Information.............")
tags.delete_many({"id": {"$nin": tag_ids}})
tag_hierarchy.delete_many({"parameter_id": {"$nin": tag_ids}})

print("Deleting Asset Model Information.............")
ilens_asset_model = connection[ilens_asset_model_details]
asset_model_details = ilens_asset_model["asset_model_details"]
query = {'asset_model_name': {'$not': {'$regex': "test", '$options': 'i'}}}
asset_model_info = asset_model_details.find(query,
                                            {"_id": 0, "asset_model_id": 1, "asset_version": 1, "asset_model_name": 1})
request_uri = f"{public_uri}/scada_dt/asset/asset_model_delete"
input_payload = {
    "project_id": project_id,
    "asset_model_id": "asset_model_101",
    "asset_version": "1.0"
}

for each in asset_model_info:
    input_payload['asset_model_id'] = each['asset_model_id']
    input_payload['asset_version'] = each['asset_version']
    print(f"Deleting Asset Model Information for {input_payload}.............")
    response = requests.post(request_uri, json=input_payload,
                             cookies={'login-token': login_token, 'projectId': project_id})
    print(response.json())
