import uuid
from datetime import datetime, timedelta

import redis
import typer
from typer import Typer

from jwt_util import Secrets, JWT

app = Typer(
    name="Generating Token",
)
jwt = JWT()


def create_token(user_id, ip, token, age=Secrets.LOCK_OUT_TIME_MINS):
    """
    This method is to create a cookie
    """
    try:
        uid = str(uuid.uuid4()).replace("-", "")

        payload = {"ip": ip, "user_id": user_id, "token": token, "uid": uid, "age": age}

        exp = datetime.utcnow() + timedelta(minutes=age)
        _extras = {"iss": Secrets.issuer, "exp": exp}
        _payload = {**payload, **_extras}

        new_token = jwt.encode(_payload)

        # Add session to redis
        login_db.set(uid, new_token)
        login_db.expire(uid, timedelta(minutes=age))

        return uid
    except Exception as e:
        print(e)
        raise


Redis_host: str = typer.prompt("Enter Redis Host to continue", default='192.168.0.220')
Redis_port: int = int(typer.prompt("Enter Redis Port to continue", default='6379'))
Redis_db: int = int(typer.prompt("Enter Redis DB to continue", default='9'))
user_details: str = typer.prompt("Enter User Id to continue", default='user_099')
ip_details: str = typer.prompt("Enter Ip to continue", default='127.0.0.1')
token_age_in_days: int = int(typer.prompt("Enter Token Age in days to continue", default='2'))
login_db = redis.Redis(
    host=Redis_host,
    port=Redis_port,
    db=Redis_db,
    decode_responses=True,
)

age_in_minutes = token_age_in_days * 24 * 60
token_details = create_token(user_id=user_details, ip=ip_details, token=Secrets.token, age=age_in_minutes)
typer.echo(typer.style(f"Token Generated for {token_age_in_days} days is {token_details}", fg=typer.colors.GREEN))
