import argparse
import sys
import uuid
from datetime import datetime, timedelta
from datetime import timezone

import redis
import typer
from typer import Typer

from jwt_util import JWT

app = Typer(
    name="Generating Token",
)
jwt = JWT()

from jwt_util import Secrets

ap = argparse.ArgumentParser()


def create_token(user_id, ip, token, age=Secrets.LOCK_OUT_TIME_MINS):
    """
    This method is to create a cookie
    """
    try:
        uid = str(uuid.uuid4()).replace("-", "")

        payload = {"ip": ip, "user_id": user_id, "token": token, "uid": uid, "age": age}

        exp = datetime.now(timezone.utc) + timedelta(minutes=age)
        _extras = {"iss": Secrets.issuer, "exp": exp}
        _payload = {**payload, **_extras}

        new_token = jwt.encode(_payload)

        # Add session to redis
        login_db.set(uid, new_token)
        login_db.expire(uid, timedelta(minutes=age))

        return uid
    except Exception as e:
        print(e)
        raise


if __name__ == "__main__":
    ap.add_argument(
        "--REDIS_URI",
        "-rc",
        required=False,
        default=None,
        help="Redis URI for the token generation..",
    )
    ap.add_argument(
        "--TOKEN_AGE",
        "-b",
        required=False,
        default=None,
        help="Token Age for the Token.",
    )
    ap.add_argument(
        "--REDIS_DB",
        "-db",
        required=False,
        default=9,
        help="Redis Db info..",
    )
    ap.add_argument(
        "--USER_ID",
        "-u",
        required=False,
        default='user_099',
        help="User_id details for the login-token",
    )
    ap.add_argument(
        "--HOST",
        "-ip",
        required=False,
        default='127.0.0.1',
        help="Ip details for the login-token",
    )
    arguments = vars(ap.parse_args())

    print(f"{arguments['REDIS_URI']}:{arguments['TOKEN_AGE']}:{arguments['REDIS_DB']}")
    REDIS_URI = arguments['REDIS_URI']
    TOKEN_AGE = arguments['TOKEN_AGE']
    REDIS_DB = arguments['REDIS_DB']
    USER_ID = arguments['USER_ID']
    ip_details = arguments['HOST']
    if not all([REDIS_URI, TOKEN_AGE, REDIS_DB]):
        sys.exit()
    login_db = redis.from_url(REDIS_URI, db=int(REDIS_DB), decode_responses=True)

    age_in_minutes = int(TOKEN_AGE) * 24 * 60
    token_details = create_token(user_id=USER_ID, ip=ip_details, token=Secrets.token, age=age_in_minutes)
    typer.echo(typer.style(f"Token Generated for {TOKEN_AGE} days is {token_details}", fg=typer.colors.GREEN))
