from flask import Blueprint, request

from scripts.config.app_constants import Endpoints, StatusMessages
from scripts.core.handler.category_configuration_handler import CategoryConfigurationHandler
from scripts.logging.logger import logger
from scripts.utils.AESEnc import apply_encryption

category_configuration = Blueprint("support_lens_blueprint", __name__)
handler_obj = CategoryConfigurationHandler()


@category_configuration.route(Endpoints.list_category, methods=['POST'])
@apply_encryption
def get_category_list():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_LIST}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.get_category_list(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@category_configuration.route(Endpoints.save_category, methods=['POST'])
@apply_encryption
def save_category_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        input_data.update(type="save")
        final_json = handler_obj.save_category_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@category_configuration.route(Endpoints.edit_category, methods=['POST'])
@apply_encryption
def edit_category_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        input_data.update(type="edit")
        final_json = handler_obj.save_category_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@category_configuration.route(Endpoints.fetch_category, methods=['POST'])
@apply_encryption
def fetch_category_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_FETCH}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.fetch_category_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@category_configuration.route(Endpoints.delete_category, methods=['POST'])
@apply_encryption
def delete_category_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.delete_category_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json
