from flask import Blueprint, request

from scripts.config.app_constants import Endpoints, StatusMessages
from scripts.core.handler.resolver_setup_handler import ResolverSetupHandler
from scripts.logging.logger import logger
from scripts.utils.AESEnc import apply_encryption

resolver_configuration = Blueprint("resolver_blueprint", __name__)
handler_obj = ResolverSetupHandler()


@resolver_configuration.route(Endpoints.list_resolver, methods=['POST'])
@apply_encryption
def get_resolver_list():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.RESOLVER_LIST}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.get_resolver_list(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@resolver_configuration.route(Endpoints.save_resolver, methods=['POST'])
@apply_encryption
def save_resolver_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.RESOLVER_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        input_data.update(type="save")
        final_json = handler_obj.save_resolver_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@resolver_configuration.route(Endpoints.edit_resolver, methods=['POST'])
@apply_encryption
def edit_resolver_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.RESOLVER_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        input_data.update(type="edit")
        final_json = handler_obj.save_resolver_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@resolver_configuration.route(Endpoints.fetch_resolver_data, methods=['POST'])
@apply_encryption
def fetch_resolver_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_FETCH}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.fetch_resolver_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@resolver_configuration.route(Endpoints.fetch_resolver_meta, methods=['POST'])
@apply_encryption
def get_resolver_metadata():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.RESOLVER_FETCH}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.get_category_metadata(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@resolver_configuration.route(Endpoints.delete_resolver, methods=['POST'])
@apply_encryption
def delete_resolve_data():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.CATEGORY_DATA}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.delete_resolver_data(input_json=input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json
