from flask import Blueprint, request

from scripts.config.app_constants import Endpoints, StatusMessages
from scripts.core.handler.supportcase_setup_handler import TicketSetupHandler
from scripts.logging.logger import logger
from scripts.utils.AESEnc import apply_encryption

supportcase_setup_configuration = Blueprint("ticket_setup_blueprint", __name__)
handler_obj = TicketSetupHandler()


@supportcase_setup_configuration.route(Endpoints.save_support_case, methods=['POST'])
@apply_encryption
def save_support_case_details():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.SUPPORTCASE_SAVE}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.save_ticket_data(input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@supportcase_setup_configuration.route(Endpoints.fetch_support_case, methods=['POST'])
@apply_encryption
def fetch_support_case_details():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.SUPPORTCASE_SAVE}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.fetch_ticket_details(input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json


@supportcase_setup_configuration.route(Endpoints.delete_support_case, methods=['POST'])
@apply_encryption
def delete_support_case_details():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.SUPPORTCASE_SAVE}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.delete_case_details(input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json



@supportcase_setup_configuration.route(Endpoints.get_support_case_table_details, methods=['POST'])
@apply_encryption
def get_support_case_table_details():
    final_json = {"status": StatusMessages.FAILED, "message": StatusMessages.SUPPORTCASE_SAVE}
    try:
        input_data = request.data
        # input_data = request.get_json()
        final_json = handler_obj.get_support_case_table_details(input_data)
    except Exception as e:
        logger.exception("Exception -> %s" % str(e))
    return final_json