class Endpoints:
    base_url = "/support_lens"

    list_category = base_url + "/category/list"
    save_category = base_url + "/category/save"
    edit_category = base_url + "/category/edit"
    fetch_category = base_url + "/category/fetch"
    delete_category = base_url + "/category/delete"

    fetch_resolver_meta = base_url + "/resolver/fetch_meta"
    fetch_resolver_data = base_url + "/resolver/fetch"
    save_resolver = base_url + "/resolver/save"
    edit_resolver = base_url + "/resolver/edit"
    delete_resolver = base_url + "/resolver/delete"
    list_resolver = base_url + "/resolver/list"

    save_support_case = base_url + "/support_case/create"
    fetch_support_case = base_url + "/support_case/fetch"
    delete_support_case = base_url + "/support_case/delete"
    edit_support_case = base_url + "/support_case/edit"
    get_support_case_table_details = base_url + "/support_case/fetch_table"


class DBMapping:
    # DBConstants
    support_lens_configuration = "supportlens_configuration"
    ilens_configuration = "ilens_configuration"

    # CollectionConstants
    category_configuration = "category_configuration"
    subcategory_configuration = "subcategory_configuration"
    resolver_configuration = "resolver_configuration"
    ticket_configuration = "ticket_configuration"
    site_conf = "site_conf"
    user = "user"
    unique_id = "unique_id"
    customer_projects = "customer_projects"


class CaseStatus:
    OPEN = "open"
    DELETE = "delete"


class StatusMessages:
    SUCCESS = "success"
    FAILED = "failed"

    CATEGORY_LIST = "Failed to fetch category list"
    CATEGORY_DATA = "Failed to save category data"
    CATEGORY_DELETE = "Failed to delete category data"
    CATEGORY_FETCH = "Failed to fetch category data"

    RESOLVER_LIST = "Failed to fetch resolver list"
    RESOLVER_DATA = "Failed to save resolver data"
    RESOLVER_DELETE = "Failed to delete resolver data"
    RESOLVER_FETCH = "Failed to fetch resolver data"

    SUPPORTCASE_SAVE = "Failed to save support case details"
    SUPPORTCASE_FETCH = "Failed to fetch support case details"


class StaticJsons:
    CATEGORY_HEADERCONTENT = [
        {
            "label": "Category Name",
            "key": "category_name"
        },
        {
            "label": "Description",
            "key": "description"
        },
        {
            "label": "Sub Categories",
            "key": "sub_categories"
        }
    ]
    RESOLEVER_HEADERCONTENT = [
        {
            "label": "Resolver Group Name",
            "key": "resolver_group_name"
        },
        {
            "label": "Description",
            "key": "description"
        },
        {
            "label": "Category",
            "key": "category"
        },
        {
            "label": "Sub Categories",
            "key": "sub_categories"
        }
    ]
    SUPPORTLENS_FETCHTABLE_HEADERCONTENT = [
        {
            "value": "case_number",
            "label": "case Number",
            "enable_column_search": True,
            "header_type": "text"
        },
        {
            "value": "subject",
            "label": "Subject",
            "enable_column_search": True,
            "header_type": "text"
        },
        {
            "value": "customer_project_id",
            "label": "Customer Project ID",
            "enable_column_search": True,
            "header_type": "text"
        },
        {
            "value": "status",
            "label": "Status",
            "enable_column_search": True,
            "header_type": "select",
            "options": []
        },
        {
            "value": "created_by",
            "label": "Created By",
            "enable_column_search": True,
            "header_type": "select",
            "options": []
        },
        {
            "value": "last_updated",
            "label": "Last Updated",
            "enable_column_search": True,
            "header_type": "date_range"
        }
    ]
    SUPPORTLENS_FETCHTABLE_TABLEACTIONS = {
        "actions": [
            {
                "action": "edit",
                "label": "Edit",
                "type": "edit",
                "icon-class": "fa fa-pencil"
            },
            {
                "action": "view",
                "label": "View",
                "type": "view",
                "icon-class": "fa fa-eye"
            },
            {
                "action": "delete",
                "label": "Delete",
                "type": "delete",
                "icon-class": "fa fa-trash"
            }
        ],
        "enableActions": True,
        "externalActions": [

        ]
    }


class MongoEncryptionConstants:
    # mongo exception codes
    MONGO001 = "Server was unable to eestablish connection with MongoDB"
    MONGO002 = "Server faced a problem when inserting document(s) into MongoDB"
    MONGO003 = "Server faced a problem to find the document(s) with the given condition"
    MONGO004 = "Server faced a problem to delete the document(s) with the given condition"
    MONGO005 = "Server faced a problem to update the document(s) with the given condition and given data"
    MONGO006 = "Server faced a problem when aggregating the data"
    MONGO007 = "Server faced a problem when closing the connection with MongoDB"

    # mongo encryption keys
    key_encrypt_keys = "encrypt_keys"
    key_exclude_encryption = "exclude_encryption"
    product_encrypted = "product_encrypted"
    max_docs_per_batch = 5
    # cipher_key = "a985195aaa464e61"
    # Product based configurable constants
    cipher_key = {
        'k': '-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEArVED5cr+tMtFtVmXl2O0cvQbEgoYSIFd8yvkmm6z7'
             'XAdX6Eg\nYkKez0ydTl26KOdJ18A7Kn8etWGe8nTkSGheJl9rn/J+lE1zpo4Zg/T3wDnM8FM3\nyuM26vpIb+0oJmNc9'
             'DkFXo4WtxRFZDytdETg/YyI+eJYDRDrZSrlqAzIDpAdLpv9\nUhsMhYQ+2n3PcauLeJb0dKPVTc6kSvGCs3LZ0WyTbRnQ'
             'yJMCWnaxzpSIUcH7qaqO\nKC/fBCKsZmRjRNSmQ3gepz4VnQKyJCm7CJk+cQiQMQzrspRPvhmGouHZUM36KjsG\n6ylx2'
             'Bu6OYy/HbrdRkJKNlv3u6BBL6Pn/ZJZGQIDAQABAoIBABI8eMhESnYbm1RI\nW8S8YzeIO1Pz13hDku7cArcEKG72kcSm'
             '58knAN5HjbK59nVI1tJ6gc84JnNH1Qlm\nZsG+p49qkWC4S3zPxHg1MfaaPzpM6qUr4G4656OkV5xdTBDz+gshd9Dp6vZ'
             'zDdUc\n9FRMTg8nqx79461mRxpzP8xloaQ0NcKBzFK9e3g/4i72LwgNP3E6xmESiu7goqJ1\nGOAI2mJie3TTY1z8sf4u'
             'iSFLMaFrExkq4z4KkwS7qF2nOJxhv8H/g9TGPNWrnzAw\nyBHwINBoUaJwiOT51xxIDLgNQiNoIFuaMKVu2l+rWtoQWKG'
             'iOnw1ZhYxeJCXByXC\nQqpAfgECgYEAwpzSfyot3PAlxm9iVK5Zc6lRdBq7Jazt7t91U6zeY7C4xzNG1Tuf\ncSYK3qRwl'
             'Mw2uXl9auxyV41rziX9sZhtFUnm4jcGv9MHeaAaSSPSsvrtZDFBS7ky\nl2Ixk1078LTZCLMYmAKCAr2XLmShBPSVcuaL'
             'kDRX4rvw7scWmMb86wECgYEA4/yC\nEAjXlL0WlOYDJ3J//Pg4iBtIedHXmn30goNuCBBaoYygXapeytEmU2q5hybQTMTX'
             '\nVl/vIAFiu0TX81VQ7LDLJaber/7GEsIT3x+xm0jFvOxFYVhT5b0s0z1CQolnRFsA\ndIwQ5u5GkP65hyJUa3ZMh+L6Vi'
             'sSCTKpAco9ZhkCgYAKFZ5CwKjHvhn3AmaSBMbV\n23xBC/GOrjtWGXY288pCWDH7AIk3G3PTpSkDCHpc+4gKbGU3WTFDoC'
             'xp7kYLId7l\nL4MrTban0gOdJdK234hXhfEvM+4yQlKAzbHL9RTaEET+0mj/14FtKu3elZBSdWoZ\nHiE1Q8EaGqsNdHuT'
             'RxxsAQKBgQCqw7enyveusPL5FE/IfDrhgArX55ehp0uWrEE4\ngLkp0RYRawOzJKlbwMy0LnxIfwoGdmnUiIbTsjYBjs8'
             'xs/WpU8LVsOeba3lxE21O\n8q5VYWy61T4ia9ZrjgbFMl0u+TwgNwlgQolmb5Lrh9/vGAejdjhcj+ZyJFCeExQE\nAzd6'
             'AQKBgBhe+FwMhTus961jqEKXBXm0/OaOgzOdgl/asuC8oLU7cAVD7sS2LFcU\nu7ofIVIG6cRWRruajIuCdlIcLOedTE4'
             'YL5jAuRL1TyVvxMm0FsrkWPABFrHWhsZs\nTSzpiOFJkLJTVnT7hlW/+m0qrKiW0zrFza0JaFwP/lj+hRrYGkOl\n'
             '-----END RSA PRIVATE KEY-----'}


class KEYS:
    cookie_encryption_private_key = "#ilenskey@rock1#"


class FILE_PATH:
    CSV_PATH = "csv"
    IMAGES = "images"
    DOCS = "docs"
    PDF = "pdf"
    TXT = "txt"
