import configparser
import os

# read config file based on already set environment variable : APP_ENV
# If  APP_ENV is null default configuration file is used
#  New application config file should be in folder with same name as environment variavble
APP_ENV = os.environ.get('APP_ENV')
if not APP_ENV:
    APP_ENV = 'app'

config = configparser.ConfigParser()
CONFIGURATION_FILE = f"conf/{APP_ENV}/application.conf"
config.read(CONFIGURATION_FILE)
if not config.read(CONFIGURATION_FILE):
    APP_ENV = "dev"
    CONFIGURATION_FILE = f"conf/{APP_ENV}/application.conf"
    config.read(CONFIGURATION_FILE)




"""
Configuration module
"""

"""
Service Info
"""

SERVICE_NAME = config["service"]["name"]
SERVICE_HOST = config["service"]["host"]
SERVICE_PORT = config.getint("service", "port")
SERVICE_SECRET_KEY = config["service"]["SECRET_KEY"]
SERVICE_ENABLE_SECURITY = config.getboolean("service", "enable_security", fallback=False)
SERVICE_INTERFACE = str(config["service"]["interface"])
DEVICE_STATUS_TIME = config.getint("service", "device_status_time_minutes", fallback=1)
APPLY_PROCESSOR_COUNT = config.getboolean("service", "apply_processor_count", fallback=False)
workers = config.getint("service", "workers", fallback=1)
threads = config.getint("service", "threads", fallback=1)
ip_check = config.getboolean("service", "ip_check", fallback=False)
FILES_SAVE_PATH = config.get("service", "files", fallback="files")


cookie_max_age = config.getint("service", "cookie_max_age_in_mins", fallback=60)
max_attempts = config.getint("service", "max_attempts")
lockout_time_interval = config.getint("service", "lockout_time_interval")
reset_time_interval = config.getfloat("service", "reset_time_interval")

http_flag = config.getboolean('service', 'httpflag')
secure_flag = config.getboolean('service', 'secureflag')

"""
Log Info
"""
LOG_FILE_NAME = config["log"]["file_name"]
LOG_PATH = config["log"]["path"]
LOG_LEVEL = config["log"]["level"]
LOG_HANDLER = config["log"]["handler"]
LOG_MAX_BYTES = config.getint("log", "max_bytes")
LOG_BACKUP_COUNT = config.getint("log", "back_up_count")

"""
Mongo Info
"""
MONGO_HOST = config["mongo_db"]["host"]
MONGO_PORT = config.getint("mongo_db", "port", fallback=2717)
MONGO_USERNAME = config["mongo_db"]["username"]
MONGO_PASSWORD = config["mongo_db"]["password"]
MONGO_AUTHSOURCE = config["mongo_db"]["authSource"]
MONGO_AUTHMECHANISM = config["mongo_db"]["authMechanism"]
encryption_constants_file_path = config["mongo_db"]["mongo_constants_file_path"]

