from flask import Flask
from scripts.config import app_configuration as conf
from scripts.core.services.category_configuration import category_configuration
from scripts.core.services.resolver_setup_configuration import resolver_configuration
from scripts.core.services.supportcase_setup_configuration import supportcase_setup_configuration
from scripts.logging.logger import logger

app = Flask(__name__)

app.register_blueprint(category_configuration)
app.register_blueprint(resolver_configuration)
app.register_blueprint(supportcase_setup_configuration)



if __name__ == "__main__":
    logger.warning("This is debug only Runtime. Run wsgi.py in production environment.\n"
                   "For more information, refer Read Me.\nFor help, contact developer. Don't screw up!")
    logger.info("Debug Runtime Starting......")
    app.run(host=conf.SERVICE_HOST, port=conf.SERVICE_PORT, debug=True, threaded=True, use_reloader=False)
