import json
import os
import sys

if __name__ == '__main__':
    from dotenv import load_dotenv

    load_dotenv()

from scripts.core.handlers import ExcelUploadHandler

def main():
    s = ExcelUploadHandler()
    files_mapping = os.environ.get("FILES_MAPPING", default="")
    if not files_mapping:
        print("Files Mapping Found empty, existing!!")
        sys.exit(0)
    files_list = json.loads(files_mapping)
    template_path = os.environ.get("TEMPLATE_PATH", default="")
    data_path = os.environ.get("DATA_PATH", default="")
    for each_file in files_list:
        _file = each_file.get("file_name")
        sheet_name = each_file.get("sheet_name")
        fill_range = each_file.get("fill_range")
        column_enabled = each_file.get("column_based")
        response = s.parse_excel_data(template_file_path=os.path.join(template_path, _file),
                                      data_file_path=os.path.join(data_path, _file),column_enabled=column_enabled,
                                      template_fill_range=fill_range, sheet_name=sheet_name, file_name=_file)

a = True
while a:
    main()