from typing import Optional, Union, List

from pydantic import BaseModel


class GetLayoutRequest(BaseModel):
    project_id: str


class LayoutData(BaseModel):
    label: Optional[str]
    value: Optional[str]
    description: Optional[str]
    show: Optional[bool]
    category: Optional[str]
    cols: Optional[int]
    rows: Optional[int]
    min_item_rows: Optional[int]
    min_item_cols: Optional[int]
    x: Optional[int]
    y: Optional[int]


class SaveLayoutRequest(BaseModel):
    data: List
    project_id: str
