from typing import Any, Optional, List

from scripts.constants import CommonKeys
from scripts.constants import DBConstants
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class LookupTableSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    lookup_id: Optional[str]
    lookup_name: Optional[str]
    lookup_data: Optional[List]
    project_id: Optional[Any]
    description: Optional[str]


class LookupTable(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DBConstants.db_metadata,
                         collection=DBConstants.collection_lookup_table)
        self.project_id = project_id

    @property
    def key_type(self):
        return CommonKeys.KEY_TYPE

    def find_constant_by_dict(self, _type):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        :param _type:
        :return:
        """
        record = self.find_one(query={self.key_type: _type})
        if not record:
            return dict(record)
        return dict(record)

    def find_lookup_dict(self, lookup_name, project_id, filter_dict=None):
        query = {self.key_type: lookup_name, "project_id": project_id}
        record = self.find_one(query=query, filter_dict=filter_dict)
        if not record:
            return dict()
        return dict(record)

    def map_lookup_keys(self, lookup_name, project_id):
        query = {self.key_type: lookup_name, "project_id": project_id}
        _record = self.find_one(query=query)
        if not _record:
            return dict()
        return {record["lookupdata_id"]: record["lookup_value"] for record in _record["lookup_data"]}

    def insert_one_constant(self, data):
        """
        The following function will insert one tag in the
        tags collections
        :param self:
        :param data:
        :return:
        """
        return self.insert_one(data)

    def find_constant_by_content(self, content_type):
        """
        The following function will give one record for a given set of
        search parameters as keyword arguments
        """
        query = {"content_type": content_type}
        search_option = {"data": 1}
        record = self.find_one(query=query, filter_dict=search_option)
        if not record:
            return dict()
        return record
