from fastapi import APIRouter
from scripts.logging import logger
from scripts.constants import Endpoints
from scripts.schemas.batch_oee import GetOeeServices
from scripts.core.handlers import oee_handlers
import traceback

from scripts.schemas.response_models import DefaultFailureResponse

oee_services = APIRouter(prefix=Endpoints.oee_services, tags=["OEE Calculator"])


@oee_services.post(Endpoints.oee_services)
async def oee_tag(oee_tag_mapping_list: GetOeeServices):
    try:
        tag_mapping = oee_tag_mapping_list.dict()
        result = oee_handlers.OeeServices.oee_tag(oee_tag_mapping_list)
        return result
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args).dict()


@oee_services.post(Endpoints.oee_services)
async def get_oee_tag(get_oee_tags: GetOeeServices):
    try:
        get_oee_tags = get_oee_tags.dict()
        return_json = oee_handlers.OeeServices.get_oee_tag(get_oee_tags)
        return return_json

    except Exception as e:
        raise logger.exception(f"Error while getting information as {e}")


@oee_services.post(Endpoints.oee_services)
async def delete_oee_tag(delete_oee_tags: GetOeeServices):
    try:
        delete_oee_tags = delete_oee_tags.dict()
        return_json = oee_handlers.OeeServices.delete_oee_tags(project_id=delete_oee_tags["project_id"])
        return return_json

    except Exception as e:
        raise logger.exception(f"Error while getting information as {e}")


@oee_services.post(Endpoints.oee_services)
async def update_oee_tag(update_oee_tags: GetOeeServices):
    try:
        update_oee_tags = update_oee_tags.dict()
        return_json = oee_handlers.OeeServices.update_oee_tags(update_oee_tags)
        return return_json

    except Exception as e:
        raise logger.exception(f"Error while getting information as {e}")
