import traceback

from fastapi import APIRouter, Request, Cookie

from scripts.constants import Endpoints, ResponseCodes
from scripts.core.handlers.meta_handler import MetaHandler
from scripts.logging.logging import logger
from scripts.schemas.meta import GetHierarchyRequest
from scripts.schemas.response_models import DefaultFailureResponse, DefaultResponse

meta_handler = MetaHandler()
meta_service_router = APIRouter(prefix=Endpoints.api_hierarchy, tags=["Meta Services"])


@meta_service_router.post(Endpoints.api_get)
async def find_hierarchy(get_hierarchy_request: GetHierarchyRequest, request: Request):
    try:
        data = await meta_handler.find_hierarchy(
            get_hierarchy_request=get_hierarchy_request, request=request
        )
        return DefaultResponse(
            data=data,
            status=ResponseCodes.SUCCESS,
            message="Hierarchies listed successfully",
        )
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args)
