import sys

from sqlalchemy import create_engine
from sqlalchemy_utils import database_exists, create_database

from scripts.config import DBConf
from scripts.db.db_models import DownTimeCategory, DownTimeLog, DownTimeMasterError
from scripts.logging import logger

engine = create_engine(DBConf.POSTGRES_URI)


def create_default_psql_dependencies():
    try:
        if not database_exists(engine.url):
            create_database(engine.url)
        DownTimeCategory.__table__.create(bind=engine, checkfirst=True)
        DownTimeMasterError.__table__.create(bind=engine, checkfirst=True)
        DownTimeLog.__table__.create(bind=engine, checkfirst=True)

    except Exception as e:
        logger.error(f"Error occurred while creating: {e}", exc_info=True)
        sys.exit()
