#  Copyright (c) NOIR
from sqlalchemy import Column, Integer, String, BigInteger, Float

from scripts.db.psql.databases import Base


class OEEDiscreteTable(Base):
    __tablename__ = "oee_discrete"
    id = Column(Integer, autoincrement=True, primary_key=True)
    hierarchy = Column(String)
    process = Column(String, nullable=True)
    reference = Column(String)
    prod_start_time = Column(BigInteger)
    prod_end_time = Column(BigInteger)
    total_downtime = Column(Float, default=0)
    cycle_time = Column(Float)
    total_units = Column(Float)
    reject_units = Column(Float, default=0)
    productive_time = Column(Float, default=0)
    availability = Column(Float)
    performance = Column(Float)
    quality = Column(Float)
    availability_loss = Column(Float)
    quality_loss = Column(Float)
    performance_loss = Column(Float)
    oee = Column(Float)
    calculated_on = Column(BigInteger)
    uom = Column(String, default="mins")
    setup_time = Column(Float, default=0)
