from collections import namedtuple


class Endpoints:
    calc_oee_base = "/calculator"
    calculate_batch_oee = "/batch_oee/calculate"
    update_batch_oee = "/batch_oee/update"

    api_batches = "/batches"
    get_batch_oee_all = "batch_oee/get/all"
    get_batch_oee_batch_id = "batch_oee/get/one_batch"
    api_get = "/get"
    api_chart_data = "/chart_data"
    get_layout = "/get_layout"
    save_layout = "/save_layout"

    # Meta services
    api_hierarchy = "/hierarchy"
    hierarchy_api = 'ilens_config/get_site_level_hierarchy'

    #OEE SERVICES
    oee_services="/oee"
    oee_services="/oee_post"



class StatusCodes:
    SUCCESS = [200, 201, 204]


class ResponseCodes:
    SUCCESS = "success"


class UOM:
    minutes = "mins"
    seconds = "secs"
    hours = "hrs"
    millis = "msecs"

    Divisor = namedtuple("Divisor", ["minutes", "seconds", "hours", "millis"])
    time_divs = Divisor(60000, 1000, 360000, 1)


class Secrets:
    LOCK_OUT_TIME_MINS = 30
    leeway_in_mins = 10
    unique_key = '45c37939-0f75'
    token = '8674cd1d-2578-4a62-8ab7-d3ee5f9a'
    issuer = "ilens"
    alg = "RS256"


class CommonKeys:
    KEY_TYPE = "type"
    KEY_CONTENT_TYPE = "content_type"


class DBConstants:
    # Databases
    db_events = "ilens_events"
    db_metadata = "ilens_configuration"
    db_ebpr = "ilens_ebpr"
    db_ilens_assistant = "ilens_assistant"

    collection_constants = "constants"
