from typing import Optional, List

from pydantic import BaseModel


class GetTagsLists(BaseModel):
    project_id: str
    hierarchy: str


class OutputTagsList(BaseModel):
    project_id: str
    hierarchy_list: Optional[List]
    hierarchy_level: Optional[str]
    hierarchy: Optional[str]

    class Config:
        schema_extra = {
            "example": {
                "project_id": "project_099",
                "hierarchy_list": ["site_101", "site_102"],
                "hierarchy_level": "equipment"
            }
        }
