import traceback

from scripts.constants.db_connections import mongo_client
from scripts.constants.db_connections import mongo_connection
from scripts.db.mongo.ilens_configuration.collections import collection_constants
from scripts.logging import logger
from scripts.schemas.oee_config_schema import Oee_Tag_Mapping_List, Get_Oee_Tag, Update_Oee_Tags, Get_Project_Id
from scripts.constants.db_connections import mongo_connection


class Oee_Services:
    def __init__(self, project_id=Get_Project_Id.project_id):
        try:
            self.connect = collection_constants(mongo_client=mongo_client)
            self.mongo_connect = mongo_connection
        except Exception as e:
            tb = traceback.format_exc()
            logger.exception(e)
            logger.exception(tb)
            logger.exception("Error while connecting to mongodb")
            raise

    def oee_tag_mapping(self, oee_tag_mapping_list: Oee_Tag_Mapping_List):
        try:
            insert_json = {"hierarchy": oee_tag_mapping_list.hierarchy,
                           "project_id": oee_tag_mapping_list.project_id,
                           "meta": oee_tag_mapping_list.project_id,
                           "oee_tag_mapping": oee_tag_mapping_list.oee_tag_mapping
                           }
            result = self.connect.insert_one(data=insert_json)
            if result:
                logger.info("Data inserted in to mongodb successfully")
            else:
                logger.info("Unable to insert data in to Mongodb")
        except Exception as e:
            tb = traceback.format_exc()
            logger.exception(e)
            logger.exception(tb)
            logger.exception("Error occurred while inserting data")
            raise

    def get_oee_tag_mapping(self, get_oee_tag: Get_Oee_Tag):
        try:
            return_json = {"message": "failure", "status": "failure", "data": "data not found"}
            query = {'project_id': get_oee_tag.project_id}
            skips = get_oee_tag.page_size * (get_oee_tag.page_num - 1)
            no_of_documents = self.connect.count_documents(query=query)
            result = self.connect.find(query=query).skip(skips).limit(get_oee_tag.page_num)
            if result:
                # if skips < no_of_documents:
                #     return_json["endOfrecords"] = False
                # else:
                #     return_json["endOfrecords"] = True
                return result
        except Exception as e:
            tb = traceback.format_exc()
            logger.exception(e)
            logger.exception(tb)
            logger.exception(f"Exception occurred while fetching data as {e}")
            raise

    def delete_oee_tags(self, project_id: Get_Project_Id):
        try:
            query = {"project_id": project_id.project_id}
            result = self.connect.delete_one(query=query)
            if result:
                return result
        except Exception as e:
            tb = traceback.format_exc()
            logger.exception(e)
            logger.exception(tb)
            logger.exception(f"Exception occurred while fetching data as {e}")
            raise

    def update_oee_tags(self, update_oee_tags: Update_Oee_Tags):
        try:
            query = {"project_id": ['update_oee_tags.project_id']}
            result = self.connect.update_one(query=query)
            if result:
                return result
        except Exception as e:
            tb = traceback.format_exc()
            logger.exception(e)
            logger.exception(tb)
            logger.exception(f"Exception occurred while fetching data as {e}")
            raise

    def get_project_tz(self):
        try:
            connection = self.mongo_connect
            project_tz = connection.find()
            return_json = {}
            for each_project in project_tz:
                for each_tz in each_project:
                    return_json.update({str(each_tz.get("customer_project_name")): str(each_tz.get("timezone"))})
            return return_json
        except Exception as e:
            logger.info("Exception occured while fetching project timezone")
