import traceback

from scripts.db.mongo.ilens_assistant.collection.tag_instance_data import TagInstanceData
from scripts.db.mongo.ilens_configuration.collections.customer_projects import CustomerProjects
from scripts.schemas.batch_oee import GetOeeServices
from scripts.constants.db_connections import mongo_client
from scripts.db.mongo.ilens_configuration.collections import collection_constants
from scripts.logging import logger
from scripts.utils.common_utils import CommonUtils

from scripts.schemas.oee_config_schema import Oee_Tag_Mapping_List, Get_Oee_Tag, Update_Oee_Tags, Get_Project_Id
from scripts.constants import CommonKeys
from scripts.db.mongo.ilens_configuration import database
from scripts.db.mongo.ilens_configuration.collections import collection_constants
from scripts.utils.mongo_util import MongoCollectionBaseClass
from scripts.schemas import mongo_schema
from sqlalchemy.orm import Session
from scripts.constants.db_connections import mongo_client
import json


class OeeServices:
    def __init__(self, project_id=None):
        try:
            self.tag_data_conn = TagInstanceData(mongo_client=mongo_client)
            self.common_utils = CommonUtils()
            self.customer_project = CustomerProjects(mongo_client=mongo_client)
            # self.hierarchy = TagInstanceData(mongo_client=mongo_client, project_id=project_id)
        except Exception as e:
            raise logger.exception(f"Error while connecting to mongodb {e.args}")

    def oee_tag(self, request_data: GetOeeServices, db: Session, user_id):
        try:
            insert_json = dict(hierarchy=request_data.hierarchy,
                               project_id=request_data.project_id,
                               meta=request_data.meta,
                               oee_tag_mapping=request_data.oee_tag_mapping
                               )
            if bool(request_data.hierarchy):
                insert_json.update(hierarchy=request_data.hierarchy)
            result = self.tag_data_conn.add_tag(insert_json)
            result.meta.update(self.common_utils.get_user_meta(user_id, check_flag=True))
            if result:
                return result
        except Exception as e:
            raise logger.exception(f"Error occurred while inserting data{e}")

    def get_oee_tag(self, request_data: GetOeeServices, db: Session):
        try:

            result = self.tag_data_conn.find_data_by_project_id(project_id=request_data.project_id)
            return result

        except Exception as e:
            raise logger.exception(f"Exception occurred while fetching data as {e}")

    def delete_oee_tags(self, request_data: GetOeeServices, db: Session):
        try:
            query = {"project_id": request_data.project_id}
            result = self.tag_data_conn.delete_one(query=query)
            if result:
                return result
        except Exception as e:
            raise logger.exception(f"Exception occurred while fetching data as {e.args}")

    def update_oee_tags(self, request_data: GetOeeServices, db: Session):
        try:
            update_json = dict(hierarchy=request_data.hierarchy,
                               project_id=request_data.project_id,
                               meta=request_data.meta,
                               oee_tag_mapping=request_data.oee_tag_mapping)
            result = self.tag_data_conn.update_tag_data(project_id=update_json["project_id"],
                                                        data=update_json, upsert=True)
            if result:
                return result
        except Exception as e:
            raise logger.exception(f"Exception occurred while fetching data as {e.args}")

    def customer_project(self, customer_project_id):
        custom_details = self.customer_project.key_customer_project_id(customer_project_id)
        for each in custom_details:
            response_data = dict({"key": each.get("customer_project_id"),
                                  "value": each.get("time_zone")})
            return response_data

# query = {'project_id': request_data.project_id}
# skips = request_data.page_size * (request_data.page_num - 1)
# no_of_documents = self.tag_data_conn.count_documents(query=query)
# result = self.tag_data_conn.find(query=query).skip(skips).limit(request_data.page_num)

# if skips < no_of_documents:
#     return_json["endOfrecords"] = False
# else:
#     return_json["endOfrecords"] = True

# meta = request_data.meta
# updated_meta=meta.update(self.common_utils.get_user_meta(user_id, check_flag=True))

# if request_data.hierarchy:
#     self.tag_data_conn.update_hierarchy_data(
#         hierarchy=insert_json["hierarchy"],
#         data=insert_json, upsert=True)
#     return insert_json["hierarchy"]
